/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Cookie;
import io.muserver.CookieBuilder;
import io.muserver.MuException;
import io.muserver.MuRequest;
import io.muserver.Mutils;
import io.muserver.UploadedFile;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.ParameterObjectBuilder;
import io.muserver.openapi.SchemaObjectBuilder;
import io.muserver.rest.CollectionParameterStrategy;
import io.muserver.rest.DescriptionData;
import io.muserver.rest.JaxRSRequest;
import io.muserver.rest.MuPathSegment;
import io.muserver.rest.MuUriInfo;
import io.muserver.rest.RequestMatcher;
import io.muserver.rest.Required;
import io.muserver.rest.UriPattern;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class ResourceMethodParam {
    final int index;
    final Parameter parameterHandle;
    final ValueSource source;
    final DescriptionData descriptionData;
    final boolean isRequired;

    ResourceMethodParam(int index, ValueSource source, Parameter parameterHandle, DescriptionData descriptionData, boolean isRequired) {
        this.index = index;
        this.source = source;
        this.parameterHandle = parameterHandle;
        this.descriptionData = descriptionData;
        this.isRequired = isRequired;
    }

    static ResourceMethodParam fromParameter(int index, Parameter parameterHandle, List<ParamConverterProvider> paramConverterProviders, UriPattern methodPattern) {
        String regex;
        String key;
        boolean isRequired;
        Pattern pattern = null;
        ValueSource source = ResourceMethodParam.getSource(parameterHandle);
        boolean bl = isRequired = source == ValueSource.PATH_PARAM || ResourceMethodParam.hasDeclared(parameterHandle, Required.class);
        if (source == ValueSource.MESSAGE_BODY) {
            DescriptionData descriptionData = DescriptionData.fromAnnotation(parameterHandle, null);
            return new MessageBodyParam(index, source, parameterHandle, descriptionData, isRequired);
        }
        if (source == ValueSource.CONTEXT) {
            return new ContextParam(index, source, parameterHandle);
        }
        if (source == ValueSource.SUSPENDED) {
            return new SuspendedParam(index, source, parameterHandle);
        }
        boolean encodedRequested = ResourceMethodParam.hasDeclared(parameterHandle, Encoded.class);
        boolean isDeprecated = ResourceMethodParam.hasDeclared(parameterHandle, Deprecated.class);
        ParamConverter<?> converter = ResourceMethodParam.getParamConverter(parameterHandle, paramConverterProviders);
        boolean lazyDefaultValue = converter.getClass().getDeclaredAnnotation(ParamConverter.Lazy.class) != null;
        boolean explicitDefault = ResourceMethodParam.hasDeclared(parameterHandle, DefaultValue.class);
        Object defaultValue = ResourceMethodParam.getDefaultValue(parameterHandle, converter, lazyDefaultValue);
        isRequired |= !explicitDefault && parameterHandle.getType().isPrimitive();
        String string = source == ValueSource.COOKIE_PARAM ? parameterHandle.getDeclaredAnnotation(CookieParam.class).value() : (source == ValueSource.HEADER_PARAM ? parameterHandle.getDeclaredAnnotation(HeaderParam.class).value() : (source == ValueSource.MATRIX_PARAM ? parameterHandle.getDeclaredAnnotation(MatrixParam.class).value() : (source == ValueSource.FORM_PARAM ? parameterHandle.getDeclaredAnnotation(FormParam.class).value() : (source == ValueSource.PATH_PARAM ? parameterHandle.getDeclaredAnnotation(PathParam.class).value() : (key = source == ValueSource.QUERY_PARAM ? parameterHandle.getDeclaredAnnotation(QueryParam.class).value() : "")))));
        if (key.length() == 0) {
            throw new WebApplicationException("No parameter specified for the " + (Object)((Object)source) + " in " + parameterHandle);
        }
        if (source == ValueSource.PATH_PARAM && methodPattern != null && (regex = methodPattern.regexFor(key)) != null) {
            pattern = Pattern.compile(regex);
        }
        DescriptionData descriptionData = DescriptionData.fromAnnotation(parameterHandle, key);
        return new RequestBasedParam(index, source, parameterHandle, defaultValue, encodedRequested, lazyDefaultValue, converter, descriptionData, key, isDeprecated, isRequired, pattern, explicitDefault);
    }

    private static ValueSource getSource(Parameter p) {
        return ResourceMethodParam.hasDeclared(p, MatrixParam.class) ? ValueSource.MATRIX_PARAM : (ResourceMethodParam.hasDeclared(p, QueryParam.class) ? ValueSource.QUERY_PARAM : (ResourceMethodParam.hasDeclared(p, FormParam.class) ? ValueSource.FORM_PARAM : (ResourceMethodParam.hasDeclared(p, PathParam.class) ? ValueSource.PATH_PARAM : (ResourceMethodParam.hasDeclared(p, CookieParam.class) ? ValueSource.COOKIE_PARAM : (ResourceMethodParam.hasDeclared(p, HeaderParam.class) ? ValueSource.HEADER_PARAM : (ResourceMethodParam.hasDeclared(p, Context.class) ? ValueSource.CONTEXT : (ResourceMethodParam.hasDeclared(p, Suspended.class) ? ValueSource.SUSPENDED : ValueSource.MESSAGE_BODY)))))));
    }

    private static boolean hasDeclared(Parameter parameterHandle, Class<? extends Annotation> annotationClass) {
        return parameterHandle.getDeclaredAnnotation(annotationClass) != null;
    }

    private static ParamConverter<?> getParamConverter(Parameter parameterHandle, List<ParamConverterProvider> paramConverterProviders) {
        Class paramType = parameterHandle.getType();
        Type parameterizedType = parameterHandle.getParameterizedType();
        if (Collection.class.isAssignableFrom(paramType) && parameterizedType instanceof ParameterizedType) {
            Type type;
            Type possiblyWildcardType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            Type type2 = type = possiblyWildcardType instanceof WildcardType ? ((WildcardType)possiblyWildcardType).getUpperBounds()[0] : possiblyWildcardType;
            if (type instanceof Class) {
                paramType = (Class)type;
            }
        }
        Annotation[] declaredAnnotations = parameterHandle.getDeclaredAnnotations();
        for (ParamConverterProvider paramConverterProvider : paramConverterProviders) {
            ParameterizedType type;
            Type rawType;
            ParameterizedType pt;
            Type[] ata;
            ParamConverter converter = paramConverterProvider.getConverter(paramType, parameterizedType, declaredAnnotations);
            if (converter == null && RequestBasedParam.createCollection(paramType) != null && parameterizedType instanceof ParameterizedType && (ata = (pt = (ParameterizedType)parameterizedType).getActualTypeArguments()).length == 1 && ata[0] instanceof ParameterizedType && (rawType = (type = (ParameterizedType)ata[0]).getRawType()) instanceof Class) {
                converter = paramConverterProvider.getConverter((Class)rawType, (Type)type, declaredAnnotations);
            }
            if (converter == null) continue;
            return converter;
        }
        throw new MuException("Could not find a suitable ParamConverter for " + parameterizedType + " at " + parameterHandle.getDeclaringExecutable());
    }

    private static Object getDefaultValue(Parameter parameterHandle, ParamConverter<?> converter, boolean lazyDefaultValue) {
        DefaultValue annotation = parameterHandle.getDeclaredAnnotation(DefaultValue.class);
        if (annotation == null) {
            return converter instanceof HasDefaultValue ? ((HasDefaultValue)converter).getDefault() : null;
        }
        return ResourceMethodParam.convertValue(parameterHandle, converter, lazyDefaultValue, annotation.value());
    }

    private static Object convertValue(Parameter parameterHandle, ParamConverter<?> converter, boolean skipConverter, Object value) {
        if (converter == null || skipConverter) {
            return value;
        }
        try {
            String valueAsString = (String)value;
            if (value != null) {
                return converter.fromString(valueAsString);
            }
            return converter instanceof HasDefaultValue ? ((HasDefaultValue)converter).getDefault() : null;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException("Could not convert String value \"" + value + "\" to a " + parameterHandle.getType() + " using " + converter + " on parameter " + parameterHandle, (Throwable)e);
        }
    }

    static interface HasDefaultValue {
        public Object getDefault();
    }

    static enum ValueSource {
        MESSAGE_BODY(null),
        QUERY_PARAM("query"),
        MATRIX_PARAM(null),
        PATH_PARAM("path"),
        COOKIE_PARAM("cookie"),
        HEADER_PARAM("header"),
        FORM_PARAM(null),
        CONTEXT(null),
        SUSPENDED(null);

        final String openAPIIn;

        private ValueSource(String openAPIIn) {
            this.openAPIIn = openAPIIn;
        }
    }

    static class SuspendedParam
    extends ResourceMethodParam {
        SuspendedParam(int index, ValueSource source, Parameter parameterHandle) {
            super(index, source, parameterHandle, null, true);
        }
    }

    static class ContextParam
    extends ResourceMethodParam {
        ContextParam(int index, ValueSource source, Parameter parameterHandle) {
            super(index, source, parameterHandle, null, true);
        }
    }

    static class MessageBodyParam
    extends ResourceMethodParam {
        MessageBodyParam(int index, ValueSource source, Parameter parameterHandle, DescriptionData descriptionData, boolean isRequired) {
            super(index, source, parameterHandle, descriptionData, isRequired);
        }
    }

    static class RequestBasedParam
    extends ResourceMethodParam {
        private final Object defaultValue;
        final boolean encodedRequested;
        private final boolean lazyDefaultValue;
        private final ParamConverter paramConverter;
        final String key;
        final boolean isDeprecated;
        private final Pattern pattern;
        private final boolean explicitDefault;

        ParameterObjectBuilder createDocumentationBuilder() {
            ParameterObjectBuilder builder = ParameterObjectBuilder.parameterObject().withIn(this.source.openAPIIn).withRequired(this.isRequired).withDeprecated(this.isDeprecated ? Boolean.valueOf(true) : null).withName(this.key);
            ExternalDocumentationObject externalDoc = null;
            if (this.descriptionData != null) {
                String desc = this.descriptionData.summaryAndDescription();
                builder.withDescription(this.key.equals(desc) ? null : desc).withExample(this.descriptionData.example);
                externalDoc = this.descriptionData.externalDocumentation;
            }
            Pattern patternIfNotDefault = this.pattern == null || "[^/]+?".equals(this.pattern.pattern()) ? null : this.pattern;
            return builder.withSchema(SchemaObjectBuilder.schemaObjectFrom(this.parameterHandle.getType(), this.parameterHandle.getParameterizedType(), this.isRequired).withDefaultValue(this.source == ValueSource.PATH_PARAM || !this.hasExplicitDefault() ? null : this.defaultValue()).withExternalDocs(externalDoc).withPattern(patternIfNotDefault).build());
        }

        RequestBasedParam(int index, ValueSource source, Parameter parameterHandle, Object defaultValue, boolean encodedRequested, boolean lazyDefaultValue, ParamConverter paramConverter, DescriptionData descriptionData, String key, boolean isDeprecated, boolean isRequired, Pattern pattern, boolean explicitDefault) {
            super(index, source, parameterHandle, descriptionData, isRequired);
            this.defaultValue = defaultValue;
            this.encodedRequested = encodedRequested;
            this.lazyDefaultValue = lazyDefaultValue;
            this.paramConverter = paramConverter;
            this.key = key;
            this.isDeprecated = isDeprecated;
            this.pattern = pattern;
            this.explicitDefault = explicitDefault;
        }

        public boolean hasExplicitDefault() {
            return this.explicitDefault;
        }

        public Object defaultValue() {
            boolean skipConverter = this.defaultValue != null && !this.lazyDefaultValue;
            return ResourceMethodParam.convertValue(this.parameterHandle, this.paramConverter, skipConverter, this.defaultValue);
        }

        public Object getValue(JaxRSRequest jaxRequest, RequestMatcher.MatchedMethod matchedMethod, CollectionParameterStrategy cps) throws IOException {
            boolean isSpecified;
            List<String> cookieValues;
            Type[] actualTypeArguments;
            Type t;
            MuRequest muRequest = jaxRequest.muRequest;
            Class<PathSegment> paramClass = this.parameterHandle.getType();
            if (UploadedFile.class.isAssignableFrom(paramClass)) {
                return muRequest.uploadedFile(this.key);
            }
            if (File.class.isAssignableFrom(paramClass)) {
                UploadedFile uf = muRequest.uploadedFile(this.key);
                return uf == null ? null : uf.asFile();
            }
            if (Collection.class.isAssignableFrom(paramClass) && (t = this.parameterHandle.getParameterizedType()) instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)t).getActualTypeArguments()).length == 1) {
                boolean isUploadedFileList;
                Type argType = actualTypeArguments[0];
                boolean bl = isUploadedFileList = argType instanceof Class && UploadedFile.class.isAssignableFrom((Class)argType);
                if (!isUploadedFileList && argType instanceof WildcardType) {
                    WildcardType wt = (WildcardType)argType;
                    for (Type upperBound : wt.getUpperBounds()) {
                        if (!(upperBound instanceof Class) || !UploadedFile.class.isAssignableFrom((Class)upperBound)) continue;
                        isUploadedFileList = true;
                        break;
                    }
                }
                if (isUploadedFileList) {
                    List<UploadedFile> uploadedFiles = muRequest.uploadedFiles(this.key);
                    if (Set.class.isAssignableFrom(paramClass)) {
                        return new HashSet<UploadedFile>(uploadedFiles);
                    }
                    return uploadedFiles;
                }
            }
            if (paramClass.isAssignableFrom(PathSegment.class)) {
                PathSegment seg = matchedMethod.pathParams.get(this.key);
                if (seg != null && this.encodedRequested) {
                    return ((MuPathSegment)seg).toEncoded();
                }
                return seg;
            }
            if (paramClass.equals(jakarta.ws.rs.core.Cookie.class)) {
                cookieValues = this.cookieValue(muRequest, this.key);
                return cookieValues.isEmpty() ? null : new jakarta.ws.rs.core.Cookie(this.key, cookieValues.get(0));
            }
            if (paramClass.equals(Cookie.class)) {
                cookieValues = this.cookieValue(muRequest, this.key);
                return cookieValues.isEmpty() ? null : new CookieBuilder().withName(this.key).withValue(cookieValues.get(0)).build();
            }
            Collection<Object> collection = RequestBasedParam.createCollection(paramClass);
            List<String> specifiedValue = this.source == ValueSource.PATH_PARAM ? Collections.singletonList(matchedMethod.getPathParam(this.key)) : (this.source == ValueSource.QUERY_PARAM ? this.getParamValues((MultivaluedMap<String, String>)jaxRequest.getUriInfo().getQueryParameters(), this.key, cps, collection != null) : (this.source == ValueSource.HEADER_PARAM ? this.getParamValues(jaxRequest.getHeaders(), this.key, cps, collection != null) : (this.source == ValueSource.FORM_PARAM ? muRequest.form().getAll(this.key) : (this.source == ValueSource.COOKIE_PARAM ? this.cookieValue(muRequest, this.key) : (this.source == ValueSource.MATRIX_PARAM ? this.matrixParamValue(this.key, jaxRequest.relativePath()) : Collections.emptyList())))));
            boolean bl = isSpecified = specifiedValue != null && !specifiedValue.isEmpty();
            if (this.encodedRequested && isSpecified) {
                specifiedValue = specifiedValue.stream().map(Mutils::urlEncode).collect(Collectors.toList());
            }
            if (collection != null) {
                if (isSpecified) {
                    for (String stringValue : specifiedValue) {
                        collection.add(ResourceMethodParam.convertValue(this.parameterHandle, this.paramConverter, false, stringValue));
                    }
                } else if (this.hasExplicitDefault()) {
                    collection.add(this.defaultValue());
                }
                return collection instanceof List ? Collections.unmodifiableList((List)collection) : (collection instanceof SortedSet ? Collections.unmodifiableSortedSet((SortedSet)collection) : (collection instanceof Set ? Collections.unmodifiableSet((Set)collection) : Collections.unmodifiableCollection(collection)));
            }
            return isSpecified ? ResourceMethodParam.convertValue(this.parameterHandle, this.paramConverter, false, specifiedValue.get(0)) : this.defaultValue();
        }

        private List<String> getParamValues(MultivaluedMap<String, String> queryParameters, String key, CollectionParameterStrategy cps, boolean isCollectionType) {
            List values = (List)queryParameters.get((Object)key);
            if (isCollectionType && values != null && cps == CollectionParameterStrategy.SPLIT_ON_COMMA) {
                ArrayList<String> copy = new ArrayList<String>(values.size());
                for (String value : values) {
                    if ((value = value.trim()).contains(",")) {
                        String[] bits = value.split("\\s*,\\s*");
                        Collections.addAll(copy, bits);
                        continue;
                    }
                    if (value.isEmpty()) continue;
                    copy.add(value.trim());
                }
                return copy;
            }
            return values;
        }

        private List<String> cookieValue(MuRequest request, String key) {
            Optional<String> cookie = request.cookie(key);
            return cookie.map(Collections::singletonList).orElse(Collections.emptyList());
        }

        private List<String> matrixParamValue(String key, String path) {
            MuPathSegment last = MuUriInfo.pathStringToSegments(path, false).reduce((first, second) -> second).orElse(null);
            if (last != null && last.getMatrixParameters().containsKey((Object)key)) {
                return (List)last.getMatrixParameters().get((Object)key);
            }
            return Collections.emptyList();
        }

        static Collection<Object> createCollection(Class<?> collectionType) {
            if (SortedSet.class.equals(collectionType)) {
                return new TreeSet<Object>();
            }
            if (Set.class.equals(collectionType)) {
                return new HashSet<Object>();
            }
            if (List.class.equals(collectionType) || Collection.class.equals(collectionType)) {
                return new ArrayList<Object>();
            }
            return null;
        }
    }
}

