/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.AsyncHandle;
import io.muserver.AsyncSsePublisher;
import io.muserver.ContentTypes;
import io.muserver.HeaderNames;
import io.muserver.Method;
import io.muserver.MuException;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.rest.AsyncResponseAdapter;
import io.muserver.rest.CORSConfig;
import io.muserver.rest.CollectionParameterStrategy;
import io.muserver.rest.CustomExceptionMapper;
import io.muserver.rest.EntityProviders;
import io.muserver.rest.FilterManagerThing;
import io.muserver.rest.JaxRSRequest;
import io.muserver.rest.JaxRSResponse;
import io.muserver.rest.JaxRsHttpHeadersAdapter;
import io.muserver.rest.JaxSseEventSinkImpl;
import io.muserver.rest.JaxSseImpl;
import io.muserver.rest.LazyAccessInputStream;
import io.muserver.rest.LazyAccessOutputStream;
import io.muserver.rest.LowercasedMultivaluedHashMap;
import io.muserver.rest.MediaTypeDeterminer;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.MuSecurityContext;
import io.muserver.rest.MuUriInfo;
import io.muserver.rest.NotMatchedException;
import io.muserver.rest.NullOutputStream;
import io.muserver.rest.ObjWithType;
import io.muserver.rest.RequestMatcher;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.ResourceMethod;
import io.muserver.rest.ResourceMethodParam;
import io.muserver.rest.SchemaObjectCustomizer;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHandler
implements MuHandler {
    private static final Logger log = LoggerFactory.getLogger(RestHandler.class);
    private final RequestMatcher requestMatcher;
    private final EntityProviders entityProviders;
    private final MuHandler documentor;
    private final CustomExceptionMapper customExceptionMapper;
    private final FilterManagerThing filterManagerThing;
    private final CORSConfig corsConfig;
    private final List<ParamConverterProvider> paramConverterProviders;
    private final SchemaObjectCustomizer schemaObjectCustomizer;
    private final List<ReaderInterceptor> readerInterceptors;
    private final List<WriterInterceptor> writerInterceptors;
    private final CollectionParameterStrategy collectionParameterStrategy;

    RestHandler(EntityProviders entityProviders, List<ResourceClass> roots, MuHandler documentor, CustomExceptionMapper customExceptionMapper, FilterManagerThing filterManagerThing, CORSConfig corsConfig, List<ParamConverterProvider> paramConverterProviders, SchemaObjectCustomizer schemaObjectCustomizer, List<ReaderInterceptor> readerInterceptors, List<WriterInterceptor> writerInterceptors, CollectionParameterStrategy collectionParameterStrategy) {
        this.requestMatcher = new RequestMatcher(roots);
        this.entityProviders = entityProviders;
        this.documentor = documentor;
        this.customExceptionMapper = customExceptionMapper;
        this.filterManagerThing = filterManagerThing;
        this.corsConfig = corsConfig;
        this.paramConverterProviders = paramConverterProviders;
        this.schemaObjectCustomizer = schemaObjectCustomizer;
        this.readerInterceptors = readerInterceptors;
        this.writerInterceptors = writerInterceptors;
        this.collectionParameterStrategy = collectionParameterStrategy;
    }

    @Override
    public boolean handle(MuRequest muRequest, MuResponse muResponse) throws Exception {
        block15: {
            List<MediaType> acceptHeaders;
            if (this.documentor != null && this.documentor.handle(muRequest, muResponse)) {
                return true;
            }
            try {
                acceptHeaders = MediaTypeDeterminer.parseAcceptHeaders(muRequest.headers().getAll(HeaderNames.ACCEPT));
            }
            catch (IllegalArgumentException e) {
                throw new ClientErrorException(e.getMessage(), 400);
            }
            List<MediaType> producesRef = null;
            List<MediaType> directlyProducesRef = null;
            MuSecurityContext securityContext = muRequest.uri().getScheme().equals("https") ? MuSecurityContext.notLoggedInHttpsContext : MuSecurityContext.notLoggedInHttpContext;
            JaxRSRequest requestContext = new JaxRSRequest(muRequest, muResponse, new LazyAccessInputStream(muRequest), Mutils.trim(muRequest.relativePath(), "/"), securityContext, this.readerInterceptors, this.entityProviders);
            try {
                RequestMatcher.MatchedMethod mm;
                this.filterManagerThing.onPreMatch(requestContext);
                Function<RequestMatcher.MatchedMethod, ResourceClass> subResourceLocator = matchedMethod -> {
                    Function<ResourceMethod, Object> onSuspended = resourceMethod -> {
                        throw new MuException("Suspended is not supported on sub-resource locators. Method: " + resourceMethod.methodHandle);
                    };
                    ResourceMethod rm = matchedMethod.resourceMethod;
                    try {
                        Object instance = RestHandler.invokeResourceMethod(requestContext, muResponse, matchedMethod, onSuspended, this.entityProviders, this.collectionParameterStrategy);
                        return ResourceClass.forSubResourceLocator(rm, instance.getClass(), instance, this.schemaObjectCustomizer, this.paramConverterProviders);
                    }
                    catch (WebApplicationException wae) {
                        throw wae;
                    }
                    catch (Exception e) {
                        throw new MuException("Error creating instance returned by sub-resource-locator " + rm.methodHandle, e);
                    }
                };
                try {
                    mm = this.requestMatcher.findResourceMethod(requestContext, requestContext.getMuMethod(), acceptHeaders, subResourceLocator);
                }
                catch (NotAllowedException e) {
                    if (requestContext.getMuMethod() == Method.HEAD) {
                        mm = this.requestMatcher.findResourceMethod(requestContext, Method.GET, acceptHeaders, subResourceLocator);
                    }
                    if (requestContext.getMuMethod() == Method.OPTIONS) {
                        Set<RequestMatcher.MatchedMethod> matchedMethodsForPath = this.requestMatcher.getMatchedMethodsForPath(requestContext.relativePath(), subResourceLocator);
                        muResponse.headers().set(HeaderNames.ALLOW, (Object)CORSConfig.getAllowedMethods(matchedMethodsForPath));
                        this.corsConfig.writeHeadersInternal(muRequest, muResponse, matchedMethodsForPath);
                        return true;
                    }
                    throw e;
                }
                this.corsConfig.writeHeadersInternal(muRequest, muResponse, Collections.singleton(mm));
                requestContext.setMatchedMethod(mm);
                producesRef = mm.resourceMethod.resourceClass.produces;
                List<MediaType> produces = producesRef;
                directlyProducesRef = mm.resourceMethod.directlyProduces;
                List<MediaType> directlyProduces = directlyProducesRef;
                Annotation[] methodAnnotations = mm.resourceMethod.methodAnnotations;
                this.filterManagerThing.onPostMatch(requestContext);
                Function<ResourceMethod, Object> suspendedParamCallback = rm -> {
                    if (muRequest.isAsync()) {
                        throw new MuException("A REST method can only have one @Suspended attribute. Error for " + rm);
                    }
                    return new AsyncResponseAdapter(muRequest.handleAsync(), response -> this.sendResponse(0, requestContext, muResponse, acceptHeaders, produces, directlyProduces, methodAnnotations, response));
                };
                Object result = RestHandler.invokeResourceMethod(requestContext, muResponse, mm, suspendedParamCallback, this.entityProviders, this.collectionParameterStrategy);
                if (!muRequest.isAsync()) {
                    if (result instanceof CompletionStage) {
                        AsyncHandle asyncHandle1 = muRequest.handleAsync();
                        CompletionStage cs = (CompletionStage)result;
                        cs.thenAccept(o -> {
                            try {
                                this.sendResponse(0, requestContext, muResponse, acceptHeaders, produces, directlyProduces, methodAnnotations, o);
                                asyncHandle1.complete();
                            }
                            catch (Exception e) {
                                asyncHandle1.complete(e);
                            }
                        });
                    } else {
                        this.sendResponse(0, requestContext, muResponse, acceptHeaders, produces, directlyProduces, methodAnnotations, result);
                    }
                }
            }
            catch (NotMatchedException e) {
                return false;
            }
            catch (Exception ex) {
                if (producesRef == null) {
                    producesRef = Collections.emptyList();
                }
                if (directlyProducesRef == null) {
                    directlyProducesRef = Collections.emptyList();
                }
                this.dealWithUnhandledException(0, requestContext, muResponse, ex, acceptHeaders, producesRef, directlyProducesRef);
                if (!muRequest.isAsync()) break block15;
                muRequest.handleAsync().complete();
            }
        }
        return true;
    }

    static Object invokeResourceMethod(JaxRSRequest requestContext, MuResponse muResponse, RequestMatcher.MatchedMethod mm, Function<ResourceMethod, Object> suspendedParamCallback, EntityProviders entityProviders, CollectionParameterStrategy collectionParameterStrategy) throws Exception {
        ResourceMethod rm = mm.resourceMethod;
        Object[] params = new Object[rm.methodHandle.getParameterCount()];
        for (ResourceMethodParam param : rm.params) {
            Object paramValue;
            if (param.source == ResourceMethodParam.ValueSource.MESSAGE_BODY) {
                paramValue = RestHandler.readRequestEntity(requestContext, param.parameterHandle);
            } else if (param.source == ResourceMethodParam.ValueSource.CONTEXT) {
                paramValue = RestHandler.getContextParam(requestContext, muResponse, mm, param, entityProviders);
            } else if (param.source == ResourceMethodParam.ValueSource.SUSPENDED) {
                paramValue = suspendedParamCallback.apply(rm);
            } else {
                ResourceMethodParam.RequestBasedParam rbp = (ResourceMethodParam.RequestBasedParam)param;
                paramValue = rbp.getValue(requestContext, mm, collectionParameterStrategy);
            }
            params[param.index] = paramValue;
        }
        return rm.invoke(params);
    }

    private void dealWithUnhandledException(int nestingLevel, JaxRSRequest request, MuResponse muResponse, Exception ex, List<MediaType> acceptHeaders, List<MediaType> producesRef, List<MediaType> directlyProducesRef) throws Exception {
        Response response = this.customExceptionMapper.toResponse(ex);
        if (response == null && ex instanceof WebApplicationException) {
            this.dealWithWebApplicationException(nestingLevel, request, muResponse, (WebApplicationException)((Object)ex), acceptHeaders, producesRef == null ? Collections.emptyList() : producesRef, directlyProducesRef == null ? Collections.emptyList() : directlyProducesRef);
        } else {
            if (response == null) {
                throw ex;
            }
            this.sendResponse(nestingLevel, request, muResponse, acceptHeaders, producesRef, directlyProducesRef, JaxRSResponse.Builder.EMPTY_ANNOTATIONS, response);
        }
    }

    private void sendResponse(int nestingLevel, JaxRSRequest requestContext, MuResponse muResponse, List<MediaType> acceptHeaders, List<MediaType> produces, List<MediaType> directlyProduces, Annotation[] annotations, Object result) throws Exception {
        block24: {
            try {
                if (requestContext.hasEntity()) {
                    requestContext.getEntityStream().close();
                }
                if (muResponse.hasStartedSendingData()) break block24;
                ObjWithType obj = ObjWithType.objType(result);
                if (obj.entity instanceof Exception) {
                    throw (Exception)obj.entity;
                }
                JaxRSResponse jaxRSResponse = obj.response;
                if (jaxRSResponse == null) {
                    jaxRSResponse = new JaxRSResponse((Response.StatusType)Response.Status.fromStatusCode((int)obj.status()), (MultivaluedMap<String, Object>)new LowercasedMultivaluedHashMap(), obj, new NewCookie[0], Collections.emptyList(), JaxRSResponse.Builder.EMPTY_ANNOTATIONS);
                }
                try (LazyAccessOutputStream out = new LazyAccessOutputStream(muResponse);){
                    Type entityGenericType;
                    Object entity;
                    jaxRSResponse.setEntityStream(requestContext.getMuMethod() == Method.HEAD ? NullOutputStream.INSTANCE : out);
                    jaxRSResponse.setRequestContext(requestContext);
                    Annotation[] writerAnnontations = annotations;
                    if (jaxRSResponse.getAnnotations().length > 0) {
                        if (writerAnnontations.length == 0) {
                            writerAnnontations = jaxRSResponse.getAnnotations();
                        } else {
                            writerAnnontations = Arrays.copyOf(annotations, annotations.length + jaxRSResponse.getAnnotations().length);
                            System.arraycopy(jaxRSResponse.getAnnotations(), 0, writerAnnontations, annotations.length, jaxRSResponse.getAnnotations().length);
                        }
                    }
                    if (obj.entity != null) {
                        MediaType responseMediaType = MediaTypeDeterminer.determine(obj, produces, directlyProduces, this.entityProviders.writers, acceptHeaders, writerAnnontations);
                        jaxRSResponse.setMediaType(responseMediaType);
                    }
                    this.filterManagerThing.onBeforeSendResponse(requestContext, jaxRSResponse);
                    if (jaxRSResponse.hasEntity()) {
                        jaxRSResponse.executeInterceptors(this.writerInterceptors);
                    }
                    if ((entity = jaxRSResponse.getEntity()) instanceof Exception) {
                        throw (Exception)entity;
                    }
                    int status = jaxRSResponse.getStatus();
                    muResponse.status(status);
                    boolean isHttp1 = requestContext.muRequest.protocol().equals("HTTP/1.1");
                    if (entity == null) {
                        if (status != 204 && status != 304 && status != 205) {
                            jaxRSResponse.getHeaders().putSingle((Object)"content-length", (Object)"0");
                        }
                        MuRuntimeDelegate.writeResponseHeaders(requestContext.muRequest.uri(), jaxRSResponse, muResponse, isHttp1);
                        break block24;
                    }
                    MediaType responseMediaType = jaxRSResponse.getMediaType();
                    Class<?> entityType = jaxRSResponse.getEntityClass();
                    MessageBodyWriter<?> messageBodyWriter = this.entityProviders.selectWriter(entityType, entityGenericType = jaxRSResponse.getEntityType(), writerAnnontations, responseMediaType);
                    long size = messageBodyWriter.getSize(entity, entityType, entityGenericType, writerAnnontations, responseMediaType);
                    if (size > -1L) {
                        jaxRSResponse.getHeaders().putSingle((Object)"content-length", (Object)size);
                    }
                    String contentType = responseMediaType.toString();
                    if (responseMediaType.getType().equals("text") && !responseMediaType.getParameters().containsKey("charset")) {
                        contentType = contentType + ";charset=utf-8";
                    }
                    jaxRSResponse.getHeaders().putSingle((Object)"content-type", (Object)contentType);
                    MuRuntimeDelegate.writeResponseHeaders(requestContext.muRequest.uri(), jaxRSResponse, muResponse, isHttp1);
                    try {
                        messageBodyWriter.writeTo(jaxRSResponse.getEntity(), jaxRSResponse.getType(), jaxRSResponse.getGenericType(), writerAnnontations, jaxRSResponse.getMediaType(), jaxRSResponse.getHeaders(), jaxRSResponse.getOutputStream());
                    }
                    catch (Exception e) {
                        if (!muResponse.hasStartedSendingData()) {
                            for (String added : jaxRSResponse.getHeaders().keySet()) {
                                muResponse.headers().remove(added);
                            }
                        }
                        throw e;
                    }
                }
            }
            catch (Exception ex) {
                this.dealWithUnhandledException(nestingLevel + 1, requestContext, muResponse, ex, acceptHeaders, produces, directlyProduces);
            }
        }
    }

    private void dealWithWebApplicationException(int nestingLevel, JaxRSRequest requestContext, MuResponse muResponse, WebApplicationException e, List<MediaType> acceptHeaders, List<MediaType> produces, List<MediaType> directlyProduces) throws Exception {
        if (muResponse.hasStartedSendingData()) {
            log.warn("A web application exception " + (Object)((Object)e) + " was thrown for " + requestContext.muRequest + ", however the response code and message cannot be sent to the client as some data was already sent.");
        } else {
            Response r = e.getResponse();
            if (nestingLevel < 2) {
                Response.ResponseBuilder toSend = Response.fromResponse((Response)r);
                if (r.getEntity() == null) {
                    toSend.type(MediaType.TEXT_HTML_TYPE);
                    String entity = "<h1>" + r.getStatus() + " " + r.getStatusInfo().getReasonPhrase() + "</h1>";
                    if (e instanceof ServerErrorException) {
                        String errorID = "ERR-" + UUID.randomUUID().toString();
                        log.info("Sending a 500 to the client with ErrorID=" + errorID + " for " + requestContext.muRequest, (Throwable)e);
                        toSend.entity((Object)(entity + "<p>ErrorID=" + errorID + "</p>"));
                    } else {
                        toSend.entity((Object)(entity + "<p>" + Mutils.htmlEncode(e.getMessage()) + "</p>"));
                    }
                }
                this.sendResponse(nestingLevel + 1, requestContext, muResponse, acceptHeaders, produces, directlyProduces, JaxRSResponse.Builder.EMPTY_ANNOTATIONS, toSend.build());
            } else {
                muResponse.status(r.getStatus());
                muResponse.contentType(ContentTypes.TEXT_PLAIN_UTF8);
                Response.StatusType statusInfo = r.getStatusInfo();
                String message = statusInfo.getStatusCode() + " " + statusInfo.getReasonPhrase() + " - " + e.getMessage();
                muResponse.write(message);
            }
        }
    }

    private static Object getContextParam(JaxRSRequest requestContext, MuResponse muResponse, RequestMatcher.MatchedMethod mm, ResourceMethodParam param, EntityProviders providers) {
        Object paramValue;
        MuRequest request = requestContext.muRequest;
        Class<?> type = param.parameterHandle.getType();
        if (type.equals(UriInfo.class)) {
            paramValue = RestHandler.createUriInfo(requestContext.relativePath(), mm, request.uri().resolve(request.contextPath() + "/"), request.uri());
        } else if (type.equals(MuResponse.class)) {
            paramValue = muResponse;
        } else if (type.equals(MuRequest.class)) {
            paramValue = request;
        } else if (type.equals(HttpHeaders.class)) {
            paramValue = new JaxRsHttpHeadersAdapter(request.headers(), request.cookies());
        } else {
            if (SecurityContext.class.isAssignableFrom(type)) {
                SecurityContext sc = requestContext.getSecurityContext();
                if (sc != null && !type.isAssignableFrom(sc.getClass())) {
                    throw new MuException("Invalid security context type: " + sc.getClass() + " being used for " + mm.resourceMethod.methodHandle);
                }
                return sc;
            }
            if (type.equals(Sse.class)) {
                return new JaxSseImpl();
            }
            if (type.equals(SseEventSink.class)) {
                AsyncSsePublisher pub = AsyncSsePublisher.start(requestContext.muRequest, muResponse);
                return new JaxSseEventSinkImpl(pub, muResponse, providers);
            }
            if (type.equals(ContainerRequestContext.class) || type.equals(Request.class)) {
                return requestContext;
            }
            throw new ServerErrorException("MuServer does not support @Context parameters with type " + type, 500);
        }
        return paramValue;
    }

    static MuUriInfo createUriInfo(String relativePath, RequestMatcher.MatchedMethod mm, URI baseUri, URI requestUri) {
        return new MuUriInfo(baseUri, requestUri, Mutils.trim(relativePath, "/"), mm);
    }

    private static Object readRequestEntity(JaxRSRequest requestContext, Parameter parameter) throws IOException {
        requestContext.setAnnotations(parameter.getDeclaredAnnotations());
        requestContext.setType(parameter.getType());
        requestContext.setGenericType(parameter.getParameterizedType());
        return requestContext.executeInterceptors();
    }
}

