/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.MuHandlerBuilder;
import io.muserver.Mutils;
import io.muserver.openapi.OpenAPIObjectBuilder;
import io.muserver.openapi.PathsObjectBuilder;
import io.muserver.openapi.SchemaObject;
import io.muserver.rest.BuiltInParamConverterProvider;
import io.muserver.rest.CORSConfig;
import io.muserver.rest.CORSConfigBuilder;
import io.muserver.rest.CollectionParameterStrategy;
import io.muserver.rest.CompositeSchemaObjectCustomizer;
import io.muserver.rest.CustomExceptionMapper;
import io.muserver.rest.Description;
import io.muserver.rest.EntityProviders;
import io.muserver.rest.FilterManagerThing;
import io.muserver.rest.OpenApiDocumentor;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.ResourceMethod;
import io.muserver.rest.ResourceMethodParam;
import io.muserver.rest.RestHandler;
import io.muserver.rest.SchemaObjectCustomizer;
import io.muserver.rest.SchemaReference;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;

public class RestHandlerBuilder
implements MuHandlerBuilder<RestHandler> {
    private final List<Object> resources = new ArrayList<Object>();
    private final List<MessageBodyWriter> customWriters = new ArrayList<MessageBodyWriter>();
    private final List<WriterInterceptor> writerInterceptors = new ArrayList<WriterInterceptor>();
    private final List<MessageBodyReader> customReaders = new ArrayList<MessageBodyReader>();
    private final List<ReaderInterceptor> readerInterceptors = new ArrayList<ReaderInterceptor>();
    private final List<ParamConverterProvider> customParamConverterProviders = new ArrayList<ParamConverterProvider>();
    private final List<SchemaReference> customSchemas = new ArrayList<SchemaReference>();
    private String openApiJsonUrl = null;
    private String openApiHtmlUrl = null;
    private OpenAPIObjectBuilder openAPIObject;
    private String openApiHtmlCss = null;
    private final Map<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>> exceptionMappers = new HashMap<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>>();
    private final List<ContainerRequestFilter> preMatchRequestFilters = new ArrayList<ContainerRequestFilter>();
    private final List<ContainerRequestFilter> requestFilters = new ArrayList<ContainerRequestFilter>();
    private final List<ContainerResponseFilter> responseFilters = new ArrayList<ContainerResponseFilter>();
    private CORSConfig corsConfig = CORSConfigBuilder.disabled().build();
    private final List<SchemaObjectCustomizer> schemaObjectCustomizers = new ArrayList<SchemaObjectCustomizer>();
    private CollectionParameterStrategy collectionParameterStrategy;

    public RestHandlerBuilder addResource(Object ... resources) {
        Mutils.notNull("resources", resources);
        this.resources.addAll(Arrays.asList(resources));
        return this;
    }

    public <T> RestHandlerBuilder addCustomWriter(MessageBodyWriter<T> writer) {
        this.customWriters.add(writer);
        return this;
    }

    public <T> RestHandlerBuilder addCustomReader(MessageBodyReader<T> reader) {
        this.customReaders.add(reader);
        return this;
    }

    public RestHandlerBuilder addCustomParamConverterProvider(ParamConverterProvider paramConverterProvider) {
        this.customParamConverterProviders.add(paramConverterProvider);
        return this;
    }

    public <P> RestHandlerBuilder addCustomParamConverter(final Class<P> paramClass, final ParamConverter<P> converter) {
        return this.addCustomParamConverterProvider(new ParamConverterProvider(){

            public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
                if (!rawType.equals(paramClass)) {
                    return null;
                }
                return converter;
            }
        });
    }

    public RestHandlerBuilder withOpenApiJsonUrl(String url) {
        this.openApiJsonUrl = url;
        return this;
    }

    public RestHandlerBuilder withOpenApiHtmlUrl(String url) {
        this.openApiHtmlUrl = url;
        return this;
    }

    public RestHandlerBuilder withCollectionParameterStrategy(CollectionParameterStrategy collectionParameterStrategy) {
        this.collectionParameterStrategy = collectionParameterStrategy;
        return this;
    }

    public RestHandlerBuilder withOpenApiHtmlCss(String css) {
        this.openApiHtmlCss = css;
        return this;
    }

    public RestHandlerBuilder withOpenApiDocument(OpenAPIObjectBuilder openAPIObject) {
        this.openAPIObject = openAPIObject;
        return this;
    }

    public <T extends Throwable> RestHandlerBuilder addExceptionMapper(Class<T> exceptionClass, ExceptionMapper<T> exceptionMapper) {
        this.exceptionMappers.put(exceptionClass, exceptionMapper);
        return this;
    }

    public RestHandlerBuilder addSchemaObjectCustomizer(SchemaObjectCustomizer customizer) {
        this.schemaObjectCustomizers.add(Objects.requireNonNull(customizer, "customizer"));
        return this;
    }

    public static RestHandlerBuilder restHandler(Object ... resources) {
        return new RestHandlerBuilder().addResource(resources);
    }

    public RestHandlerBuilder withCORS(CORSConfig corsConfig) {
        this.corsConfig = corsConfig;
        return this;
    }

    public RestHandlerBuilder withCORS(CORSConfigBuilder corsConfig) {
        return this.withCORS(corsConfig.build());
    }

    public RestHandlerBuilder addRequestFilter(ContainerRequestFilter filter) {
        if (filter.getClass().getDeclaredAnnotation(PreMatching.class) != null) {
            this.preMatchRequestFilters.add(filter);
        } else {
            this.requestFilters.add(filter);
        }
        return this;
    }

    public RestHandlerBuilder addResponseFilter(ContainerResponseFilter filter) {
        this.responseFilters.add(filter);
        return this;
    }

    public RestHandlerBuilder addCustomSchema(Class<?> dataClass, SchemaObject schema) {
        Description desc = dataClass.getDeclaredAnnotation(Description.class);
        String id = desc != null ? desc.value() : dataClass.getSimpleName();
        while (true) {
            boolean anyMatch = false;
            for (SchemaReference customSchema : this.customSchemas) {
                if (!customSchema.id.equals(id)) continue;
                anyMatch = true;
                break;
            }
            if (!anyMatch) break;
            id = id + "0";
        }
        String regex = "^[a-zA-Z0-9.\\-_]+$";
        if (!id.matches(regex)) {
            throw new IllegalArgumentException("The ID " + id + " given for custom schema for class " + dataClass.getName() + " does not match required regex " + regex);
        }
        this.customSchemas.add(new SchemaReference(id, dataClass, null, schema));
        return this;
    }

    public RestHandlerBuilder addWriterInterceptor(WriterInterceptor writerInterceptor) {
        if (writerInterceptor != null) {
            this.writerInterceptors.add(writerInterceptor);
        }
        return this;
    }

    public RestHandlerBuilder addReaderInterceptor(ReaderInterceptor readerInterceptor) {
        if (readerInterceptor != null) {
            this.readerInterceptors.add(0, readerInterceptor);
        }
        return this;
    }

    public List<Object> resources() {
        return Collections.unmodifiableList(this.resources);
    }

    public List<MessageBodyWriter<?>> customWriters() {
        return this.customWriters.stream().map(w -> w).collect(Collectors.toList());
    }

    public List<WriterInterceptor> writerInterceptors() {
        return Collections.unmodifiableList(this.writerInterceptors);
    }

    public List<MessageBodyReader<?>> customReaders() {
        return this.customReaders.stream().map(r -> r).collect(Collectors.toList());
    }

    public List<ReaderInterceptor> readerInterceptors() {
        return Collections.unmodifiableList(this.readerInterceptors);
    }

    public List<ParamConverterProvider> customParamConverterProviders() {
        return Collections.unmodifiableList(this.customParamConverterProviders);
    }

    public Map<Class<?>, SchemaObject> customSchemas() {
        return this.customSchemas.stream().collect(Collectors.toMap(ref -> ref.type, ref -> ref.schema));
    }

    public String openApiJsonUrl() {
        return this.openApiJsonUrl;
    }

    public String openApiHtmlUrl() {
        return this.openApiHtmlUrl;
    }

    public OpenAPIObjectBuilder openAPIObject() {
        return this.openAPIObject;
    }

    public String openApiHtmlCss() {
        return this.openApiHtmlCss;
    }

    public Map<Class<? extends Throwable>, ExceptionMapper<? extends Throwable>> exceptionMappers() {
        return Collections.unmodifiableMap(this.exceptionMappers);
    }

    public List<ContainerRequestFilter> preMatchRequestFilters() {
        return Collections.unmodifiableList(this.preMatchRequestFilters);
    }

    public List<ContainerRequestFilter> requestFilters() {
        return Collections.unmodifiableList(this.requestFilters);
    }

    public List<ContainerResponseFilter> responseFilters() {
        return Collections.unmodifiableList(this.responseFilters);
    }

    public CORSConfig corsConfig() {
        return this.corsConfig;
    }

    public List<SchemaObjectCustomizer> schemaObjectCustomizers() {
        return Collections.unmodifiableList(this.schemaObjectCustomizers);
    }

    public CollectionParameterStrategy collectionParameterStrategy() {
        return this.collectionParameterStrategy;
    }

    @Override
    public RestHandler build() {
        List<MessageBodyReader> readers = EntityProviders.builtInReaders();
        readers.addAll(this.customReaders);
        List<MessageBodyWriter> writers = EntityProviders.builtInWriters();
        writers.addAll(this.customWriters);
        EntityProviders entityProviders = new EntityProviders(readers, writers);
        ArrayList<ParamConverterProvider> paramConverterProviders = new ArrayList<ParamConverterProvider>(this.customParamConverterProviders);
        paramConverterProviders.add(new BuiltInParamConverterProvider());
        ArrayList<ResourceClass> list = new ArrayList<ResourceClass>();
        CompositeSchemaObjectCustomizer schemaObjectCustomizer = new CompositeSchemaObjectCustomizer(this.schemaObjectCustomizers);
        for (Object resource : this.resources) {
            if (!(resource instanceof SchemaObjectCustomizer) || this.schemaObjectCustomizers.contains(resource)) continue;
            this.schemaObjectCustomizers.add((SchemaObjectCustomizer)resource);
        }
        for (Object restResource : this.resources) {
            list.add(ResourceClass.fromObject(restResource, paramConverterProviders, schemaObjectCustomizer));
        }
        List<ResourceClass> roots = Collections.unmodifiableList(list);
        OpenApiDocumentor documentor = null;
        if (this.openApiHtmlUrl != null || this.openApiJsonUrl != null) {
            if (this.openApiHtmlCss == null) {
                InputStream cssStream = RestHandlerBuilder.class.getResourceAsStream("/io/muserver/resources/api.css");
                Scanner scanner = new Scanner(cssStream, "UTF-8").useDelimiter("\\A");
                this.openApiHtmlCss = scanner.next();
                scanner.close();
            }
            OpenAPIObjectBuilder openAPIObjectToUse = this.openAPIObject == null ? OpenAPIObjectBuilder.openAPIObject() : this.openAPIObject;
            openAPIObjectToUse.withPaths(PathsObjectBuilder.pathsObject().build());
            documentor = new OpenApiDocumentor(roots, this.openApiJsonUrl, this.openApiHtmlUrl, openAPIObjectToUse.build(), this.openApiHtmlCss, this.corsConfig, new ArrayList<SchemaReference>(this.customSchemas), schemaObjectCustomizer, paramConverterProviders);
        }
        CustomExceptionMapper customExceptionMapper = new CustomExceptionMapper(this.exceptionMappers);
        FilterManagerThing filterManagerThing = new FilterManagerThing(this.preMatchRequestFilters, this.requestFilters, this.responseFilters);
        CollectionParameterStrategy cps = this.collectionParameterStrategy;
        if (cps == null) {
            for (ResourceClass root : roots) {
                for (ResourceMethod rm : root.resourceMethods) {
                    for (ResourceMethodParam param : rm.params) {
                        if (!Collection.class.isAssignableFrom(param.parameterHandle.getType()) || param.source != ResourceMethodParam.ValueSource.HEADER_PARAM && param.source != ResourceMethodParam.ValueSource.QUERY_PARAM) continue;
                        throw new IllegalStateException("Please specify a string handling strategy for collections for querystring and header parameters. Please note that the behaviour of these parameters have changed since Mu Server 0.70.0 to follow the JAX-RS standard. Previously, a parameter values such as 'one,two,three' when passed to a collection parameter would be interpreted as 3 values, however the JAX-RS standard is for this to be a single value. To follow the standard, please use RestHandlerBuilder.withCollectionParameterStrategy(CollectionParameterStrategy.NO_TRANSFORM) or keep early behaviour where the value is split into multiple values, use RestHandlerBuilder.withCollectionParameterStrategy(CollectionParameterStrategy.SPLIT_ON_COMMA) no your rest handler builder instance.");
                    }
                }
            }
            cps = CollectionParameterStrategy.NO_TRANSFORM;
        }
        return new RestHandler(entityProviders, roots, documentor, customExceptionMapper, filterManagerThing, this.corsConfig, paramConverterProviders, schemaObjectCustomizer, this.readerInterceptors, this.writerInterceptors, cps);
    }
}

