/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.util.Copy;
import io.mvnpm.esbuild.util.QuteTemplateRenderer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AutoEntryPoint
implements EntryPoint {
    private static final Set<String> SCRIPTS = Set.of("js", "ts", "jsx", "tsx");
    private final String name;
    private final Path rootDir;
    private final List<String> scripts;

    public AutoEntryPoint(Path rootDir, String name, List<String> scripts) {
        this.name = name;
        this.rootDir = rootDir;
        this.scripts = scripts;
    }

    @Override
    public Path process(Path workDir) {
        try {
            if (!Objects.equals(this.rootDir, workDir)) {
                Copy.copyEntries(this.rootDir, this.scripts, workDir);
            }
            return this.bundleScripts(workDir, this.name, this.scripts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path bundleScripts(Path workDir, String bundleName, List<String> scripts) throws IOException {
        String entryString = this.convert(workDir, scripts);
        Path entry = workDir.resolve("%s.js".formatted(bundleName));
        Files.writeString(entry, (CharSequence)entryString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return entry;
    }

    private String convert(Path workDir, List<String> scripts) {
        return QuteTemplateRenderer.render("entrypoint-template.js", Map.of("imports", scripts.stream().map(path -> {
            String fileName = Path.of(path, new String[0]).getFileName().toString();
            int index = fileName.lastIndexOf(".");
            String name = fileName.substring(0, index);
            String ext = fileName.substring(index + 1);
            boolean isScript = SCRIPTS.contains(ext);
            HashMap<String, String> imports = new HashMap<String, String>();
            imports.put("from", isScript ? path.substring(0, path.lastIndexOf(".")) : path);
            imports.put("as", isScript ? name.replaceAll("-", "") : null);
            return imports;
        })));
    }
}

