/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PackageJson {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(PackageJson.class.getName());
    public static final String PACKAGE_JSON = "package.json";

    public static Optional<Path> findPackageJson(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Optional.empty();
        }
        return PackageJson.findBreadthFirst(dir);
    }

    private static Optional<Path> findBreadthFirst(Path dir) {
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.add(dir);
        while (!queue.isEmpty()) {
            Path current = (Path)queue.poll();
            if (Files.isRegularFile(current.resolve(PACKAGE_JSON), new LinkOption[0])) {
                logger.log(Level.FINE, "package.json found in ''{0}''", current);
                return Optional.of(current.resolve(PACKAGE_JSON));
            }
            try {
                Stream<Path> list = Files.list(current);
                try {
                    list.sorted().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(Predicate.not(Files::isSymbolicLink)).forEach(queue::add);
                }
                finally {
                    if (list == null) continue;
                    list.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public static String readPackageName(Path packageJson) {
        try {
            JsonNode object = objectMapper.readTree(packageJson.toFile());
            return object.get("name").asText();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

