/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.BuildEventListener;
import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Execute;
import io.mvnpm.esbuild.Watch;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleResult;
import io.mvnpm.esbuild.model.BundleType;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.ExecuteResult;
import io.mvnpm.esbuild.resolve.ExecutableResolver;
import io.mvnpm.esbuild.util.Copy;
import io.mvnpm.esbuild.util.JarInspector;
import io.mvnpm.esbuild.util.UnZip;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Bundler {
    private static final Logger logger = Logger.getLogger(Bundler.class.getName());
    private static final String NODE_MODULES = "node_modules";
    private static final String DIST = "dist";
    public static final String ESBUILD_EMBEDDED_VERSION = Bundler.resolveEmbeddedVersion();

    private static String resolveEmbeddedVersion() {
        Properties properties = new Properties();
        try {
            InputStream resource = Bundler.class.getResourceAsStream("/version.properties");
            if (resource != null) {
                properties.load(resource);
            }
        }
        catch (IOException resource) {
            // empty catch block
        }
        String version = properties.getProperty("esbuild.version");
        return Objects.requireNonNull(version, "Make sure the version.properties contains 'esbuild.version'.");
    }

    public static BundleResult bundle(BundleOptions bundleOptions) throws IOException {
        Path workDir = Bundler.installIfNeeded(bundleOptions);
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        ExecuteResult executeResult = Bundler.esBuild(esBuildConfig);
        if (!Files.isDirectory(dist, new LinkOption[0])) {
            throw new BundleException("Unexpected Error during bundling", executeResult.output());
        }
        return new BundleResult(dist, executeResult);
    }

    private static EsBuildConfig createBundle(BundleOptions bundleOptions, Path workDir, Path dist) throws IOException {
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        Copy.deleteRecursive(dist);
        Files.createDirectories(dist, new FileAttribute[0]);
        esBuildConfig.setOutdir(dist.toString());
        List<String> paths = bundleOptions.getEntries().stream().map(entry -> entry.process(workDir).toString()).toList();
        esBuildConfig.setEntryPoint((String[])paths.toArray(String[]::new));
        return esBuildConfig;
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener) throws IOException {
        Path workDir = Bundler.installIfNeeded(bundleOptions);
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        bundleOptions.getEsBuildConfig().setWatch(true);
        Process process = Bundler.esBuild(esBuildConfig, eventListener);
        return new Watch(process, workDir);
    }

    public static Path installIfNeeded(BundleOptions bundleOptions) throws IOException {
        if (bundleOptions.getWorkDir() != null && Files.isDirectory(bundleOptions.getWorkDir().resolve(NODE_MODULES), new LinkOption[0])) {
            return bundleOptions.getWorkDir();
        }
        return Bundler.install(bundleOptions);
    }

    public static Path install(BundleOptions bundleOptions) throws IOException {
        Path workingDir = bundleOptions.getWorkDir() != null ? bundleOptions.getWorkDir() : Files.createTempDirectory("bundle", new FileAttribute[0]);
        return Bundler.extract(workingDir, bundleOptions.getDependencies(), bundleOptions.getType());
    }

    public static Path install(Path workingDir, List<Path> dependencies, BundleType type) throws IOException {
        return Bundler.extract(workingDir, dependencies, type);
    }

    public static void clearDependencies(Path workingDir) throws IOException {
        Copy.deleteRecursive(workingDir.resolve(NODE_MODULES));
    }

    protected static Path extract(Path bundleDirectory, List<Path> dependencies, BundleType type) throws IOException {
        Path nodeModules = bundleDirectory.resolve(NODE_MODULES);
        if (!Files.exists(nodeModules, new LinkOption[0])) {
            Files.createDirectories(nodeModules, new FileAttribute[0]);
        }
        Path tmp = bundleDirectory.resolve("tmp");
        for (Path path : dependencies) {
            String fileName = path.getFileName().toString();
            Path extractDir = tmp.resolve(fileName.substring(0, fileName.lastIndexOf(".")));
            if (Files.isDirectory(extractDir, new LinkOption[0])) continue;
            UnZip.unzip(path, extractDir);
            Map<String, Path> packageNameAndRoot = JarInspector.findPackageNameAndRoot(extractDir, type);
            if (!packageNameAndRoot.isEmpty()) {
                for (Map.Entry<String, Path> nameAndRoot : packageNameAndRoot.entrySet()) {
                    String packageName = nameAndRoot.getKey();
                    Path source = nameAndRoot.getValue();
                    Path target = nodeModules.resolve(packageName);
                    if (!Files.isDirectory(target, new LinkOption[0])) {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    logger.log(Level.INFO, "skipping package as it already exists ''{0}''", target);
                }
                continue;
            }
            logger.log(Level.INFO, "package.json not found in package: ''{0}''", fileName);
        }
        return bundleDirectory;
    }

    protected static Process esBuild(EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_EMBEDDED_VERSION);
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.execute(listener);
    }

    protected static ExecuteResult esBuild(EsBuildConfig esBuildConfig) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_EMBEDDED_VERSION);
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.executeAndWait();
    }
}

