/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.AutoEntryPoint;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleType;
import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.EsBuildConfigBuilder;
import io.mvnpm.esbuild.model.FileEntryPoint;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class BundleOptionsBuilder {
    private final BundleOptions options = new BundleOptions();

    public BundleOptionsBuilder() {
        this.options.setEsBuildConfig(BundleOptionsBuilder.useDefaultConfig());
    }

    private static EsBuildConfig useDefaultConfig() {
        return new EsBuildConfigBuilder().build();
    }

    public BundleOptionsBuilder addAutoEntryPoint(Path sourceDir, String name, List<String> scripts) {
        return this.addEntryPoint(new AutoEntryPoint(sourceDir, name, scripts));
    }

    public BundleOptionsBuilder addEntryPoint(Path rootDir, String script) {
        this.addEntryPoint(new FileEntryPoint(rootDir, script));
        return this;
    }

    protected BundleOptionsBuilder addEntryPoint(EntryPoint entry) {
        if (this.options.getEntries() == null) {
            this.options.setEntries(new ArrayList<EntryPoint>());
        }
        this.options.getEntries().add(entry);
        return this;
    }

    public BundleOptionsBuilder setWorkFolder(Path workFolder) {
        this.options.setWorkDir(workFolder);
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<Path> dependencies) {
        this.options.setDependencies(dependencies);
        return this;
    }

    public BundleOptionsBuilder withType(BundleType type) {
        this.options.setType(type);
        return this;
    }

    public BundleOptionsBuilder withEsConfig(EsBuildConfig esBuildConfig) {
        this.options.setEsBuildConfig(esBuildConfig);
        return this;
    }

    public BundleOptions build() {
        return this.options;
    }
}

