/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mvnpm.esbuild.model.BundleType;
import io.mvnpm.esbuild.util.PackageJsonCreator;
import io.mvnpm.importmap.ImportsDataBinding;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarInspector {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(JarInspector.class.getName());
    public static final String PACKAGE_JSON = "package.json";
    public static final String IMPORTMAP_JSON = "importmap.json";
    public static final String POM_PROPERTIES = "pom.properties";
    private static final String MAVEN_ROOT = "META-INF/maven";
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    private static final String MVNPM_PACKAGE_PREFIX = "META-INF/resources/_static";
    private static final List<String> MULTIPLE_GROUP_IDS = List.of("org.mvnpm.at.mvnpm");

    public static Map<String, Path> findPackageNameAndRoot(Path extractDir, BundleType type) {
        Path dir = JarInspector.getBundleTypeRootPath(extractDir, type);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Map.of();
        }
        Properties properties = JarInspector.getProperties(extractDir, type);
        String groupId = properties.getProperty("groupId", "");
        boolean shouldDoMultiple = MULTIPLE_GROUP_IDS.contains(groupId);
        Map<String, Path> found = JarInspector.findPackageNameAndRootWithPackage(dir, shouldDoMultiple);
        if (found.isEmpty() && type.equals((Object)BundleType.MVNPM)) {
            found = JarInspector.findPackageNameAndRootWithImportMap(extractDir, properties);
        }
        return found;
    }

    private static Path getBundleTypeRootPath(Path extractDir, BundleType type) {
        if (type.equals((Object)BundleType.MVNPM)) {
            return extractDir.resolve(MVNPM_PACKAGE_PREFIX);
        }
        if (type.equals((Object)BundleType.WEBJARS)) {
            return extractDir.resolve(WEBJAR_PACKAGE_PREFIX);
        }
        throw new RuntimeException("Unknown Bundle Type " + type);
    }

    private static Properties getProperties(Path extractDir, BundleType type) {
        Properties properties = new Properties();
        if (type.equals((Object)BundleType.MVNPM)) {
            properties = JarInspector.getPomProperties(extractDir);
        }
        return properties;
    }

    private static Map<String, Path> findPackageNameAndRootWithPackage(Path root, boolean shouldDoMultiple) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        List<Path> foundFiles = JarInspector.searchFiles(root, PACKAGE_JSON, shouldDoMultiple);
        for (Path path : foundFiles) {
            String packageName = JarInspector.readPackageName(path);
            paths.putIfAbsent(packageName, path.getParent());
        }
        return paths;
    }

    private static Map<String, Path> findPackageNameAndRootWithImportMap(Path root, Properties properties) {
        Optional<Path> importMapJson = JarInspector.searchFile(root, IMPORTMAP_JSON);
        if (importMapJson.isPresent()) {
            try {
                Path importMap = importMapJson.get();
                String json = new String(Files.readAllBytes(importMap));
                Map imports = ImportsDataBinding.toImports((String)json).getImports();
                String packageName = JarInspector.readPackageName(properties);
                String artifactId = properties.getProperty("artifactId");
                String version = properties.getProperty("version");
                Path fullExtractedRoot = null;
                String fullExtractedMain = null;
                for (Map.Entry ie : imports.entrySet()) {
                    if (((String)ie.getKey()).endsWith("/") && fullExtractedRoot == null) {
                        Path resources = importMap.getParent().resolve("resources");
                        Path packageRoot = Path.of(resources.toString(), JarInspector.toRelativeDir((String)ie.getValue(), artifactId));
                        fullExtractedRoot = root.resolve(packageRoot);
                        continue;
                    }
                    if (fullExtractedMain != null) continue;
                    fullExtractedMain = (String)ie.getValue();
                }
                String main = JarInspector.toRelativeMain(fullExtractedRoot.toString(), fullExtractedMain);
                PackageJsonCreator.createPackageJson(fullExtractedRoot, packageName, version, main);
                return Map.of(packageName, fullExtractedRoot);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return Map.of();
    }

    private static String toRelativeDir(String path, String artifactId) {
        if (!path.endsWith(artifactId + "/")) {
            path = path.substring(0, path.indexOf(artifactId) + artifactId.length() + 1);
        }
        return path;
    }

    private static String toRelativeMain(String root, String main) {
        root = root.substring(root.indexOf("_static"));
        Path rootPath = Paths.get(root, new String[0]);
        if (main.startsWith("/")) {
            main = main.substring(1);
        }
        return rootPath.relativize(Paths.get(main, new String[0])).toString();
    }

    private static String readPackageName(Properties properties) {
        Object groupId = properties.getProperty("groupId");
        if (((String)groupId).equals("org.mvnpm")) {
            groupId = "";
        } else {
            groupId = ((String)groupId).substring(10);
            groupId = ((String)groupId).replaceFirst("at.", "@");
            groupId = (String)groupId + "/";
        }
        return (String)groupId + properties.getProperty("artifactId");
    }

    private static String readPackageName(Path path) {
        try {
            JsonNode object = objectMapper.readTree(path.toFile());
            return object.get("name").asText();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Properties getPomProperties(Path extractDir) {
        Properties properties = new Properties();
        Path metaInfMavenDir = extractDir.resolve(MAVEN_ROOT);
        Optional<Path> maybePomProperties = JarInspector.searchFile(extractDir.resolve(MAVEN_ROOT), POM_PROPERTIES);
        if (maybePomProperties.isPresent()) {
            Path pomProperties = maybePomProperties.get();
            try {
                properties.load(Files.newInputStream(pomProperties, new OpenOption[0]));
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "could not read properties ''{0}''", pomProperties);
            }
        }
        return properties;
    }

    private static Optional<Path> searchFile(Path rootPath, String targetFileName) {
        List<Path> found = JarInspector.searchFiles(rootPath, targetFileName, false);
        if (!found.isEmpty()) {
            return Optional.of(found.get(0));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Path> searchFiles(Path rootPath, String targetFileName, boolean multiple) {
        ArrayList<Path> found = new ArrayList<Path>();
        LinkedList<Path> queue = new LinkedList<Path>();
        queue.add(rootPath);
        block8: while (!queue.isEmpty()) {
            Path currentPath = (Path)queue.poll();
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(currentPath);
                try {
                    Iterator<Path> iterator = stream.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block8;
                        Path entry = iterator.next();
                        if (Files.isDirectory(entry, new LinkOption[0])) {
                            queue.add(entry);
                            continue;
                        }
                        if (!entry.getFileName().toString().equals(targetFileName)) continue;
                        found.add(entry);
                        if (!multiple) break;
                    }
                    ArrayList<Path> arrayList = found;
                    return arrayList;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return found;
    }
}

