/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.BuildEventListener;
import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Execute;
import io.mvnpm.esbuild.Watch;
import io.mvnpm.esbuild.install.WebDepsInstaller;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleResult;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.ExecuteResult;
import io.mvnpm.esbuild.resolve.ExecutableResolver;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;

public class Bundler {
    private static final Logger logger = Logger.getLogger(Bundler.class.getName());
    private static final String DIST = "dist";
    public static final String ESBUILD_EMBEDDED_VERSION = Bundler.resolveEmbeddedVersion();

    private static String resolveEmbeddedVersion() {
        Properties properties = new Properties();
        try {
            InputStream resource = Bundler.class.getResourceAsStream("/version.properties");
            if (resource != null) {
                properties.load(resource);
            }
        }
        catch (IOException resource) {
            // empty catch block
        }
        String version = properties.getProperty("esbuild.version");
        return Objects.requireNonNull(version, "Make sure the version.properties contains 'esbuild.version'.");
    }

    public static BundleResult bundle(BundleOptions bundleOptions, boolean install) throws IOException {
        Path workDir = Bundler.getWorkDir(bundleOptions);
        if (install) {
            Bundler.install(workDir, bundleOptions);
        }
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        ExecuteResult executeResult = Bundler.esBuild(esBuildConfig);
        if (!Files.isDirectory(dist, new LinkOption[0])) {
            throw new BundleException("Unexpected Error during bundling", executeResult.output());
        }
        return new BundleResult(dist, executeResult);
    }

    private static EsBuildConfig createBundle(BundleOptions bundleOptions, Path workDir, Path dist) throws IOException {
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        PathUtils.deleteRecursive(dist);
        Files.createDirectories(dist, new FileAttribute[0]);
        esBuildConfig.setOutdir(dist.toString());
        List<String> paths = bundleOptions.getEntries().stream().map(entry -> entry.process(workDir).toString()).toList();
        esBuildConfig.setEntryPoint((String[])paths.toArray(String[]::new));
        return esBuildConfig;
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener) throws IOException {
        Path workDir = Bundler.getWorkDir(bundleOptions);
        Bundler.install(workDir, bundleOptions);
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        bundleOptions.getEsBuildConfig().setWatch(true);
        Process process = Bundler.esBuild(esBuildConfig, eventListener);
        return new Watch(process, workDir);
    }

    private static Path getWorkDir(BundleOptions bundleOptions) throws IOException {
        return bundleOptions.getWorkDir() != null ? bundleOptions.getWorkDir() : Files.createTempDirectory("bundle", new FileAttribute[0]);
    }

    public static boolean install(Path workDir, BundleOptions bundleOptions) throws IOException {
        Path nodeModulesDir = bundleOptions.getNodeModulesDir() == null ? workDir.resolve("node_modules") : bundleOptions.getNodeModulesDir();
        return WebDepsInstaller.install(nodeModulesDir, bundleOptions.getDependencies());
    }

    public static void clearDependencies(Path nodeModulesDir) throws IOException {
        PathUtils.deleteRecursive(nodeModulesDir);
    }

    protected static Process esBuild(EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_EMBEDDED_VERSION);
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.execute(listener);
    }

    protected static ExecuteResult esBuild(EsBuildConfig esBuildConfig) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_EMBEDDED_VERSION);
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.executeAndWait();
    }
}

