/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.BuildEventListener;
import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.ExecuteResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Execute {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "Process stdout streamer");
        t.setDaemon(true);
        return t;
    });
    private static final Logger logger = Logger.getLogger(Execute.class.getName());
    private final File esBuildExec;
    private EsBuildConfig esBuildConfig;
    private String[] args;

    public Execute(File esBuildExec, EsBuildConfig esBuildConfig) {
        this.esBuildExec = esBuildExec;
        this.esBuildConfig = esBuildConfig;
    }

    public Execute(File esBuildExec, String[] args) {
        this.esBuildExec = esBuildExec;
        this.args = args;
    }

    public ExecuteResult executeAndWait() throws IOException {
        Process process = this.createProcess(this.getCommand(), Optional.empty());
        try {
            int exitCode = process.waitFor();
            String content = Execute.readStream(process.getInputStream());
            String errors = Execute.readStream(process.getErrorStream());
            if (exitCode != 0) {
                throw new BundleException(errors.isEmpty() ? "Unexpected Error during bundling" : errors, content);
            }
            return new ExecuteResult(content);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public Process execute(BuildEventListener listener) throws IOException {
        return this.createProcess(this.getCommand(), Optional.of(listener));
    }

    private String[] getCommand() {
        CharSequence[] command;
        CharSequence[] charSequenceArray = command = this.args != null ? this.getCommand(this.args) : this.getCommand(this.esBuildConfig);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "running esbuild with flags: \n > `{0}`", String.join((CharSequence)" ", command));
        }
        return command;
    }

    private String[] getCommand(EsBuildConfig esBuildConfig) {
        String[] params = esBuildConfig.toParams();
        return this.getCommand(params);
    }

    private String[] getCommand(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(args.length + 1);
        argList.add(this.esBuildExec.toString());
        argList.addAll(Arrays.asList(args));
        return (String[])argList.toArray(String[]::new);
    }

    public Process createProcess(String[] command, Optional<BuildEventListener> listener) throws IOException {
        Process process = new ProcessBuilder(new String[0]).command(command).start();
        InputStream s = process.getErrorStream();
        if (listener.isPresent()) {
            EXECUTOR.execute(new Streamer(process::isAlive, s, listener.get()));
        }
        return process;
    }

    private static String readStream(InputStream stream) {
        StringBuilder s = new StringBuilder();
        Execute.consumeStream(() -> true, stream, l -> s.append((String)l).append("\n"));
        return s.toString();
    }

    private static void consumeStream(BooleanSupplier shouldStop, InputStream stream, Consumer<String> newLineConsumer) {
        try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(in);){
            String line;
            while ((line = reader.readLine()) != null && shouldStop.getAsBoolean()) {
                newLineConsumer.accept(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private record Streamer(BooleanSupplier isAlive, InputStream processStream, BuildEventListener listener) implements Runnable
    {
        @Override
        public void run() {
            StringBuilder errorBuilder = new StringBuilder();
            Execute.consumeStream(this.isAlive, this.processStream, l -> {
                logger.fine((String)l);
                if (l.contains("[ERROR]") || !errorBuilder.isEmpty()) {
                    errorBuilder.append("\n").append((String)l);
                } else if (l.contains("build finished")) {
                    logger.info("Build finished!");
                    this.listener.onChange();
                }
            });
        }
    }
}

