/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EsBuildConfig {
    private boolean bundle;
    private String[] entryPoint;
    private boolean minify;
    private boolean version;
    private Map<String, String> substitutes;
    private List<String> excludes;
    private Format format;
    private Map<String, Loader> loader;
    private String outdir;
    private String packages;
    private Platform platform;
    private boolean serve;
    private boolean sourceMap;
    private boolean splitting;
    private Target target;
    private String watch;
    private String chunkNames;
    private String entryNames;
    private String assetNames;
    private String publicPath;
    private final List<String> external = new ArrayList<String>();

    public boolean isBundle() {
        return this.bundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    public String[] getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String[] entryPoint) {
        this.entryPoint = entryPoint;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public void setMinify(boolean minify) {
        this.minify = minify;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public Map<String, String> getSubstitutes() {
        return this.substitutes;
    }

    public void setSubstitutes(Map<String, String> substitutes) {
        this.substitutes = substitutes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Map<String, Loader> getLoader() {
        return this.loader;
    }

    public void setLoader(Map<String, Loader> loader) {
        this.loader = loader;
    }

    public String getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        this.outdir = outdir;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public boolean isServe() {
        return this.serve;
    }

    public void setServe(boolean serve) {
        this.serve = serve;
    }

    public boolean isSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(boolean sourceMap) {
        this.sourceMap = sourceMap;
    }

    public boolean isSplitting() {
        return this.splitting;
    }

    public void setSplitting(boolean splitting) {
        this.splitting = splitting;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public boolean isWatch() {
        return this.watch != null;
    }

    public void setWatch(boolean watch) {
        this.watch = watch ? "forever" : null;
    }

    public String getChunkNames() {
        return this.chunkNames;
    }

    public void setChunkNames(String chunkNames) {
        this.chunkNames = chunkNames;
    }

    public String getEntryNames() {
        return this.entryNames;
    }

    public void setEntryNames(String entryNames) {
        this.entryNames = entryNames;
    }

    public String getAssetNames() {
        return this.assetNames;
    }

    public void setAssetNames(String assetNames) {
        this.assetNames = assetNames;
    }

    public List<String> getExternal() {
        return this.external;
    }

    public void addExternal(String name) {
        this.external.add(name);
    }

    public String getPublicPath() {
        return this.publicPath;
    }

    public void setPublicPath(String publicPath) {
        this.publicPath = publicPath;
    }

    public String[] toParams() {
        Field[] fields = EsBuildConfig.class.getDeclaredFields();
        ArrayList<Object> result = new ArrayList<Object>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                if (value == null) continue;
                String fieldName = field.getName();
                if (value == Boolean.TRUE) {
                    result.add("--" + fieldName.toLowerCase());
                    continue;
                }
                if (value instanceof List) {
                    ((List)value).forEach(e -> result.add("--%s:%s".formatted(this.convertField(fieldName), e.toString())));
                    continue;
                }
                if (value instanceof Map) {
                    result.addAll(EsBuildConfig.mapToString(fieldName, (Map)value));
                    continue;
                }
                if ("entryPoint".equals(field.getName())) {
                    result.addAll(List.of((String[])value));
                    continue;
                }
                if (value instanceof Boolean) continue;
                String fn = this.convertField(fieldName);
                String v = value.toString();
                if (!fn.equals("outdir")) {
                    v = v.toLowerCase();
                }
                result.add("--%s=%s".formatted(fn, v));
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }
        return (String[])result.toArray(String[]::new);
    }

    private String convertField(String field) {
        String[] split = field.split("(?=\\p{Upper})");
        return Arrays.stream(split).map(String::toLowerCase).collect(Collectors.joining("-"));
    }

    private static List<String> mapToString(String fieldName, Map<?, ?> map) {
        ArrayList<String> result = new ArrayList<String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.add("--%s:%s=%s".formatted(fieldName, entry.getKey(), entry.getValue().toString().toLowerCase().replaceAll("_", "-")));
        }
        return result;
    }

    static enum Format {
        IIFE,
        CJS,
        ESM;

    }

    static enum Platform {
        BROWSER,
        NODE,
        NEUTRAL;

    }

    static enum Target {
        ES2017,
        CHROME58,
        FIREFOX57,
        SAFARI11,
        EDGE16,
        NODE10,
        IE9,
        OPERA45;

    }

    public static enum Loader {
        BASE64,
        BINARY,
        COPY,
        CSS,
        DATAURL,
        LOCAL_CSS,
        GLOBAL_CSS,
        EMPTY,
        FILE,
        JS,
        JSON,
        JSX,
        TEXT,
        TS,
        TSX;

    }
}

