/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.resolve;

import io.mvnpm.esbuild.resolve.BaseResolver;
import io.mvnpm.esbuild.resolve.Resolver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class DownloadResolver
extends BaseResolver
implements Resolver {
    private static final String URL_TEMPLATE = "https://registry.npmjs.org/@esbuild/%1$s/-/%1$s-%2$s.tgz";
    private static final String FILE_NAME = "esbuild.tgz";

    public DownloadResolver(Resolver resolver) {
        super(resolver);
    }

    @Override
    public Path resolve(String version) throws IOException {
        String url = URL_TEMPLATE.formatted(CLASSIFIER, version);
        Path destination = DownloadResolver.createDestination(version);
        Path tarFile = destination.resolve(FILE_NAME);
        try {
            this.downloadFile(new URL(url), tarFile);
            return DownloadResolver.extract(Files.newInputStream(tarFile, new OpenOption[0]), destination.toFile());
        }
        catch (IOException e) {
            return this.resolver.resolve(version);
        }
    }

    void downloadFile(URL url, Path destination) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
        try (FileOutputStream fileOutputStream = new FileOutputStream(destination.toFile());){
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
    }
}

