/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AutoEntryPoint
implements EntryPoint {
    private static final Set<String> SCRIPTS = Set.of("js", "ts", "jsx", "tsx", "mjs", "mts", "cjs", "cts");
    private final String name;
    private final Path rootDir;
    private final List<String> scripts;
    private static final String EXPORT = "export * from \"./%s\";";
    private static final String IMPORT = "import \"./%s\";";

    public AutoEntryPoint(Path rootDir, String name, List<String> scripts) {
        this.name = name;
        this.rootDir = rootDir;
        this.scripts = scripts;
    }

    @Override
    public Path process(Path workDir) {
        try {
            if (!Objects.equals(this.rootDir, workDir)) {
                PathUtils.copyEntries(this.rootDir, this.scripts, workDir);
            }
            return this.bundleScripts(workDir, this.name, this.scripts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path bundleScripts(Path workDir, String bundleName, List<String> scripts) throws IOException {
        String entryString = this.convert(workDir, scripts);
        Path entry = workDir.resolve("%s.js".formatted(bundleName));
        Files.writeString(entry, (CharSequence)entryString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return entry;
    }

    private String convert(Path workDir, List<String> scripts) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            for (String script : scripts) {
                String line;
                int index;
                String fileName = Path.of(script, new String[0]).getFileName().toString();
                String ext = fileName.substring((index = fileName.lastIndexOf(".")) + 1);
                boolean isScript = SCRIPTS.contains(ext);
                if (isScript) {
                    script = script.substring(0, script.lastIndexOf("."));
                    line = EXPORT.formatted(script);
                } else {
                    line = IMPORT.formatted(script);
                }
                sw.write(line);
                sw.write("\n");
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        sw.close();
        return string;
    }
}

