/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.AutoEntryPoint;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.EsBuildConfigBuilder;
import io.mvnpm.esbuild.model.FileEntryPoint;
import io.mvnpm.esbuild.model.WebDependency;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class BundleOptionsBuilder {
    private final BundleOptions options = new BundleOptions();

    public BundleOptionsBuilder() {
        this.options.setEsBuildConfig(BundleOptionsBuilder.useDefaultConfig());
    }

    private static EsBuildConfig useDefaultConfig() {
        return new EsBuildConfigBuilder().build();
    }

    public BundleOptionsBuilder addAutoEntryPoint(Path sourceDir, String name, List<String> sources) {
        return this.addEntryPoint(AutoEntryPoint.withoutAutoDeps(sourceDir, name, sources));
    }

    public BundleOptionsBuilder addAutoEntryPoint(Path sourceDir, String name, List<String> sources, AutoEntryPoint.AutoDepsMode mode, Predicate<String> autoDepsIdsPredicate) {
        return this.addEntryPoint(AutoEntryPoint.withAutoDeps(sourceDir, name, sources, new AutoEntryPoint.AutoDeps(mode, this.options.getNodeModulesDir(), autoDepsIdsPredicate)));
    }

    public BundleOptionsBuilder addEntryPoint(Path rootDir, String script) {
        this.addEntryPoint(new FileEntryPoint(rootDir, script));
        return this;
    }

    public BundleOptionsBuilder addEntryPoint(String script) {
        if (this.options.getWorkDir() == null) {
            throw new IllegalArgumentException("Workdir must be set");
        }
        this.addEntryPoint(new FileEntryPoint(this.options.getWorkDir(), script));
        return this;
    }

    protected BundleOptionsBuilder addEntryPoint(EntryPoint entry) {
        if (this.options.getEntries() == null) {
            this.options.setEntries(new ArrayList<EntryPoint>());
        }
        this.options.getEntries().add(entry);
        return this;
    }

    public BundleOptionsBuilder withNodeModulesDir(Path nodeModulesDir) {
        this.options.setNodeModulesDir(nodeModulesDir);
        return this;
    }

    public BundleOptionsBuilder withWorkDir(Path workDir) {
        this.options.setWorkDir(workDir);
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<Path> dependencies, WebDependency.WebDependencyType type) {
        this.options.setDependencies(dependencies.stream().map(d -> WebDependency.of(d, type)).toList());
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<WebDependency> dependencies) {
        this.options.setDependencies(dependencies);
        return this;
    }

    public BundleOptionsBuilder withEsConfig(EsBuildConfig esBuildConfig) {
        this.options.setEsBuildConfig(esBuildConfig);
        return this;
    }

    public BundleOptions build() {
        return this.options;
    }
}

