/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.AutoEntryPoint;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.FileEntryPoint;
import io.mvnpm.esbuild.model.WebDependency;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class BundleOptionsBuilder {
    List<EntryPoint> entries = new ArrayList<EntryPoint>();
    List<WebDependency> dependencies = new ArrayList<WebDependency>();
    EsBuildConfig esBuildConfig = EsBuildConfig.builder().build();
    Path workDir;
    Path nodeModulesDir;

    BundleOptionsBuilder() {
    }

    public BundleOptionsBuilder addAutoEntryPoint(Path sourceDir, String name, List<String> sources) {
        return this.addEntryPoint(AutoEntryPoint.withoutAutoDeps(sourceDir, name, sources));
    }

    public BundleOptionsBuilder addAutoEntryPoint(Path sourceDir, String name, List<String> sources, AutoEntryPoint.AutoDepsMode mode, Predicate<String> autoDepsIdsPredicate) {
        return this.addEntryPoint(AutoEntryPoint.withAutoDeps(sourceDir, name, sources, new AutoEntryPoint.AutoDeps(mode, this.nodeModulesDir, autoDepsIdsPredicate)));
    }

    public BundleOptionsBuilder addEntryPoint(Path rootDir, String script) {
        this.addEntryPoint(new FileEntryPoint(rootDir, script));
        return this;
    }

    public BundleOptionsBuilder addEntryPoint(String script) {
        if (this.workDir == null) {
            throw new IllegalArgumentException("Workdir must be set");
        }
        this.addEntryPoint(new FileEntryPoint(this.workDir, script));
        return this;
    }

    protected BundleOptionsBuilder addEntryPoint(EntryPoint entry) {
        this.entries.add(entry);
        return this;
    }

    public BundleOptionsBuilder withNodeModulesDir(Path nodeModulesDir) {
        this.nodeModulesDir = nodeModulesDir;
        return this;
    }

    public BundleOptionsBuilder withWorkDir(Path workDir) {
        this.workDir = workDir;
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<Path> dependencies, WebDependency.WebDependencyType type) {
        this.dependencies = dependencies.stream().map(d -> WebDependency.of(d, type)).toList();
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<WebDependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public BundleOptionsBuilder withEsConfig(EsBuildConfig esBuildConfig) {
        this.esBuildConfig = esBuildConfig;
        return this;
    }

    public BundleOptions build() {
        return new BundleOptions(this);
    }
}

