/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.resolve;

import io.mvnpm.esbuild.resolve.DownloadResolver;
import io.mvnpm.esbuild.resolve.Resolver;
import io.mvnpm.esbuild.resolve.Resolvers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Logger;

public class BundledResolver
implements Resolver {
    private static final Logger logger = Logger.getLogger(DownloadResolver.class.getName());
    private final Resolver fallbackResolver;

    public BundledResolver(Resolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
    }

    @Override
    public Path resolve(String version) throws IOException {
        Path path = Resolvers.getLocation(version);
        Path executablePath = Resolvers.resolveExecutablePath(path);
        if (Files.isExecutable(path)) {
            return executablePath;
        }
        String tgz = Resolvers.getTgzPath(version);
        InputStream resource = this.getClass().getResourceAsStream(tgz);
        if (resource != null) {
            Path bundleDir = Resolvers.extract(resource, version);
            return Resolvers.requireExecutablePath(bundleDir);
        }
        return this.fallbackResolver.resolve(version);
    }
}

