/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class Archives {
    public static void unzip(Path source, Path target) throws IOException {
        try (InputStream is = Files.newInputStream(source, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             ZipInputStream zip = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                Archives.extractEntry(target, entry.getName(), entry.isDirectory(), zip);
            }
        }
    }

    public static void unTgz(Path source, Path target) throws IOException {
        try (InputStream is = Files.newInputStream(source, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             GzipCompressorInputStream gzis = new GzipCompressorInputStream((InputStream)bis);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzis);){
            TarArchiveEntry entry;
            while ((entry = tar.getNextTarEntry()) != null) {
                Archives.extractEntry(target, entry.getName(), entry.isDirectory(), (InputStream)tar);
            }
        }
    }

    private static void extractEntry(Path target, String name, boolean isDirectory, InputStream is) throws IOException {
        Path newPath = Archives.entrySlipProtect(name, target);
        if (isDirectory) {
            Files.createDirectories(newPath, new FileAttribute[0]);
        } else {
            if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(is, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static Path entrySlipProtect(String name, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(name);
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad entry: " + name);
        }
        return normalizePath;
    }
}

