/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PackageJsonCreator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectNode browser = mapper.createObjectNode();

    private PackageJsonCreator() {
    }

    public static void createPackageJson(Path root, String name, String version, String main) {
        try {
            ObjectWriter writer = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            ObjectNode content = PackageJsonCreator.createNode(name, version, main);
            Path packageJson = root.resolve("package.json");
            writer.writeValue(Files.newOutputStream(packageJson, new OpenOption[0]), (Object)content);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static ObjectNode createNode(String name, String version, String main) {
        ObjectNode node = mapper.createObjectNode();
        node.put("name", name);
        node.put("version", version);
        node.put("main", main);
        node.set("browser", (JsonNode)browser);
        return node;
    }

    static {
        browser.put("fs", false);
        browser.put("path", false);
        browser.put("os", false);
    }
}

