/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.BuildEventListener;
import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.Execute;
import io.mvnpm.esbuild.Watch;
import io.mvnpm.esbuild.install.WebDepsInstaller;
import io.mvnpm.esbuild.model.BundleOptions;
import io.mvnpm.esbuild.model.BundleResult;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.ExecuteResult;
import io.mvnpm.esbuild.model.WatchStartResult;
import io.mvnpm.esbuild.resolve.Resolver;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;

public class Bundler {
    private static final Logger logger = Logger.getLogger(Bundler.class.getName());
    public static final String ESBUILD_EMBEDDED_VERSION = Bundler.resolveEmbeddedVersion();

    private static String resolveEmbeddedVersion() {
        Properties properties = new Properties();
        try {
            InputStream resource = Bundler.class.getResourceAsStream("/esbuild-java-version.properties");
            if (resource != null) {
                properties.load(resource);
            }
        }
        catch (IOException resource) {
            // empty catch block
        }
        String version = properties.getProperty("esbuild.version");
        return Objects.requireNonNull(version, "Make sure the esbuild-java-version.properties contains 'esbuild.version'.");
    }

    public static BundleResult bundle(BundleOptions bundleOptions, boolean install) throws IOException {
        Path workDir = Bundler.getWorkDir(bundleOptions);
        if (install) {
            Bundler.install(workDir, bundleOptions);
        }
        String out = bundleOptions.esBuildConfig().outdir() != null ? bundleOptions.esBuildConfig().outdir() : "dist";
        Path dist = workDir.resolve(out);
        EsBuildConfig esBuildConfig = Bundler.prepareForBundling(bundleOptions, workDir, dist, false);
        ExecuteResult executeResult = Bundler.esBuild(workDir, esBuildConfig);
        if (!Files.isDirectory(dist, new LinkOption[0])) {
            throw new BundleException("Unexpected Error during bundling", executeResult.output());
        }
        return new BundleResult(dist, workDir, executeResult);
    }

    private static EsBuildConfig prepareForBundling(BundleOptions bundleOptions, Path workDir, Path dist, boolean watch) throws IOException {
        EsBuildConfig esBuildConfig = bundleOptions.esBuildConfig();
        PathUtils.deleteRecursive(dist);
        Files.createDirectories(dist, new FileAttribute[0]);
        if (bundleOptions.entries() == null) {
            throw new IllegalArgumentException("At least one entry point is required");
        }
        List<String> paths = bundleOptions.entries().stream().map(entry -> entry.process(workDir).toString()).toList();
        return esBuildConfig.edit().outDir(dist.toString()).watch(watch).entryPoint((String[])paths.toArray(String[]::new)).build();
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener, boolean install) throws IOException {
        Path workDir = Bundler.getWorkDir(bundleOptions);
        if (install) {
            Bundler.install(workDir, bundleOptions);
        }
        String out = bundleOptions.esBuildConfig().outdir() != null ? bundleOptions.esBuildConfig().outdir() : "dist";
        Path dist = workDir.resolve(out);
        EsBuildConfig esBuildConfig = Bundler.prepareForBundling(bundleOptions, workDir, dist, true);
        WatchStartResult r = Bundler.esBuildWatch(workDir, esBuildConfig, eventListener);
        return new Watch(r.process(), workDir, dist, r.firstBuildResult());
    }

    private static Path getWorkDir(BundleOptions bundleOptions) throws IOException {
        return bundleOptions.workDir() != null ? bundleOptions.workDir() : Files.createTempDirectory("bundle", new FileAttribute[0]);
    }

    public static boolean install(Path workDir, BundleOptions bundleOptions) throws IOException {
        Path nodeModulesDir = Bundler.getNodeModulesDir(workDir, bundleOptions);
        return WebDepsInstaller.install(nodeModulesDir, bundleOptions.dependencies());
    }

    protected static Path getNodeModulesDir(Path workDir, BundleOptions bundleOptions) {
        return bundleOptions.nodeModulesDir() == null ? workDir.resolve("node_modules") : bundleOptions.nodeModulesDir();
    }

    public static void clearDependencies(Path nodeModulesDir) throws IOException {
        PathUtils.deleteRecursive(nodeModulesDir);
    }

    protected static WatchStartResult esBuildWatch(Path workDir, EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Execute execute = Bundler.getExecute(workDir, esBuildConfig);
        return execute.watch(listener);
    }

    protected static ExecuteResult esBuild(Path workDir, EsBuildConfig esBuildConfig) throws IOException {
        Execute execute = Bundler.getExecute(workDir, esBuildConfig);
        return execute.executeAndWait();
    }

    private static Execute getExecute(Path workDir, EsBuildConfig esBuildConfig) throws IOException {
        String version = esBuildConfig.esBuildVersion() != null ? esBuildConfig.esBuildVersion() : ESBUILD_EMBEDDED_VERSION;
        Path esBuildExec = Resolver.create().resolve(version);
        return new Execute(workDir, esBuildExec.toFile(), esBuildConfig);
    }
}

