/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PathUtils {
    private static final Logger logger = Logger.getLogger(PathUtils.class.getName());

    public static void copyEntries(Path rootDir, List<String> entries, Path targetDir) {
        for (String entry : entries) {
            try {
                Path src = rootDir.resolve(entry);
                if (!Files.exists(src, new LinkOption[0])) {
                    throw new IOException("Entry file not found: " + String.valueOf(src));
                }
                Path dest = targetDir.resolve(entry);
                if (!Files.exists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void deleteRecursive(Path source) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static void safeMove(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileSystemException exception) {
            logger.log(Level.WARNING, "encountered ''{0}'' while moving ''{1}'' to ''{2}'', falling back to secondary method", new Object[]{exception.getClass().getName(), source, target});
            ArrayList<Path> copied = new ArrayList<Path>(0);
            try (Stream<Path> paths = Files.walk(source, FileVisitOption.FOLLOW_LINKS);){
                for (Path p : paths.toList()) {
                    if (!Files.exists(p, new LinkOption[0])) {
                        return;
                    }
                    Path targetPath = target.resolve(source.relativize(p));
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                        continue;
                    }
                    if (!Files.isRegularFile(p, new LinkOption[0])) continue;
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    try {
                        Files.move(p, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (FileSystemException moveException) {
                        Files.copy(p, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        copied.add(p);
                    }
                }
            }
            for (Path toDelete : copied) {
                try {
                    Files.deleteIfExists(toDelete);
                }
                catch (Exception ex) {
                    logger.warning("could not delete ''{0}'' after copy");
                }
            }
            PathUtils.deleteRecursive(source);
        }
    }

    public static String hash(Path target) throws IOException {
        if (Files.isRegularFile(target, new LinkOption[0])) {
            String string;
            block10: {
                InputStream fileInputStream = Files.newInputStream(target, StandardOpenOption.READ);
                try {
                    int read;
                    MessageDigest md = MessageDigest.getInstance("SHA-512");
                    byte[] buffer = new byte[16384];
                    while ((read = fileInputStream.read(buffer)) >= 0) {
                        md.update(buffer, 0, read);
                    }
                    byte[] digest = md.digest();
                    string = Base64.getEncoder().encodeToString(digest);
                    if (fileInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
                fileInputStream.close();
            }
            return string;
        }
        return "";
    }
}

