/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.model;

import io.mvnpm.maven.locker.Checksum;
import io.mvnpm.maven.locker.model.ArtifactIdentifier;
import io.mvnpm.maven.locker.model.MavenArtifact;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class Artifact
implements Comparable<Artifact> {
    public static final String DEFAULT_SCOPE = "compile";
    public final ArtifactIdentifier identifier;
    public final String version;
    public final String scope;
    public final boolean optional;
    public final String integrity;

    public static ArtifactIdentifierBuilderStage builder() {
        return new ArtifactIdentifierBuilderStage();
    }

    private static String checkIntegrityArgument(String integrity) {
        Objects.requireNonNull(integrity);
        if (!StringUtils.startsWith((CharSequence)integrity, (CharSequence)"sha512:")) {
            throw new IllegalArgumentException("Encountered unsupported checksum format, consider using a later version of this plugin");
        }
        return integrity;
    }

    public static Artifact from(org.apache.maven.artifact.Artifact artifact) {
        return new Artifact(ArtifactIdentifier.builder().groupId(artifact.getGroupId()).artifactId(artifact.getArtifactId()).classifier(Optional.ofNullable(artifact.getClassifier())).type(Optional.ofNullable(artifact.getType())).build(), artifact.getVersion(), artifact.getScope(), artifact.isOptional(), Checksum.forFile(artifact.getFile()));
    }

    public org.apache.maven.artifact.Artifact toMavenArtifact() {
        return new MavenArtifact(this);
    }

    private Artifact(ArtifactIdentifier identifier, String version, String scope, boolean optional, String integrity) {
        this.identifier = Objects.requireNonNull(identifier);
        this.version = Objects.requireNonNull(version);
        this.scope = Objects.requireNonNull(scope);
        this.optional = optional;
        this.integrity = integrity;
    }

    public Artifact withVersion(String version) {
        return new Artifact(this.identifier, version, this.scope, this.optional, this.integrity);
    }

    @Override
    public int compareTo(Artifact other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return this.toStringBuilder_withoutIntegrity().append('@').append(this.integrity).toString();
    }

    public String toString_withoutIntegrity() {
        return this.toStringBuilder_withoutIntegrity().toString();
    }

    private StringBuilder toStringBuilder_withoutIntegrity() {
        return new StringBuilder().append(this.identifier.toString()).append(':').append(this.version).append(':').append(this.scope).append(":optional=").append(this.optional);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.identifier);
        hash = 17 * hash + Objects.hashCode(this.version);
        hash = 17 * hash + Objects.hashCode(this.scope);
        hash = 17 * hash + Objects.hashCode(this.optional);
        hash = 17 * hash + Objects.hashCode(this.integrity);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        if (!Objects.equals(this.optional, other.optional)) {
            return false;
        }
        return Objects.equals(this.integrity, other.integrity);
    }

    public boolean equals_ignoreVersion(Artifact other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        if (!Objects.equals(this.optional, other.optional)) {
            return false;
        }
        return Objects.equals(this.integrity, other.integrity);
    }

    public static final class ArtifactIdentifierBuilderStage {
        private ArtifactIdentifierBuilderStage() {
        }

        public VersionBuilderStage artifactIdentifier(ArtifactIdentifier artifactIdentifier) {
            return new VersionBuilderStage(Objects.requireNonNull(artifactIdentifier));
        }
    }

    public static final class FinalBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;
        private final String version;
        private final String scope;
        private final boolean optional;
        private final String integrity;

        private FinalBuilderStage(ArtifactIdentifier artifactIdentifier, String version, String scope, boolean optional, String integrity) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
            this.scope = scope;
            this.optional = optional;
            this.integrity = integrity;
        }

        public Artifact build() {
            return new Artifact(this.artifactIdentifier, this.version, this.scope, this.optional, this.integrity);
        }
    }

    public static final class IntegrityBuilderStage {
        public final ArtifactIdentifier artifactIdentifier;
        private final String version;
        private final String scope;
        private final boolean optional;

        private IntegrityBuilderStage(ArtifactIdentifier artifactIdentifier, String version, String scope, boolean optional) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
            this.scope = scope;
            this.optional = optional;
        }

        public FinalBuilderStage integrity(String integrity) {
            return new FinalBuilderStage(this.artifactIdentifier, this.version, this.scope, this.optional, Artifact.checkIntegrityArgument(integrity));
        }
    }

    public static final class OptionalBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;
        private final String version;
        private final String scope;

        private OptionalBuilderStage(ArtifactIdentifier artifactIdentifier, String version, String scope) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
            this.scope = scope;
        }

        public IntegrityBuilderStage optional(boolean optional) {
            return this.integrityBuilderStage(optional);
        }

        public FinalBuilderStage integrity(String integrity) {
            return this.integrityBuilderStage(false).integrity(integrity);
        }

        private IntegrityBuilderStage integrityBuilderStage(boolean optional) {
            return new IntegrityBuilderStage(this.artifactIdentifier, this.version, this.scope, optional);
        }
    }

    public static final class ScopeBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;
        private final String version;

        private ScopeBuilderStage(ArtifactIdentifier artifactIdentifier, String version) {
            this.artifactIdentifier = artifactIdentifier;
            this.version = version;
        }

        public OptionalBuilderStage scope(String scope) {
            return new OptionalBuilderStage(this.artifactIdentifier, this.version, Objects.requireNonNull(scope));
        }
    }

    public static final class VersionBuilderStage {
        private final ArtifactIdentifier artifactIdentifier;

        private VersionBuilderStage(ArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public ScopeBuilderStage version(String version) {
            return new ScopeBuilderStage(this.artifactIdentifier, Objects.requireNonNull(version));
        }
    }
}

