/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;

public final class ArtifactIdentifier
implements Comparable<ArtifactIdentifier> {
    public static final String DEFAULT_TYPE = "jar";
    public final String groupId;
    public final String artifactId;
    public final Optional<String> classifier;
    public final String type;

    public static ArtifactIdentifier from(Artifact artifact) {
        return new ArtifactIdentifier(artifact.getGroupId(), artifact.getArtifactId(), Optional.ofNullable(artifact.getClassifier()), Optional.ofNullable(artifact.getType()).orElse(DEFAULT_TYPE));
    }

    private ArtifactIdentifier(String groupId, String artifactId, Optional<String> classifier, String type) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.classifier = Objects.requireNonNull(classifier);
        this.type = Objects.requireNonNull(type);
    }

    public String key() {
        return this.groupId + "--" + this.artifactId;
    }

    public static GroupIdBuilderStage builder() {
        return new GroupIdBuilderStage();
    }

    @Override
    public int compareTo(ArtifactIdentifier other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':').append(this.artifactId);
        this.classifier.ifPresent(actualClassifier -> sb.append(':').append((String)actualClassifier));
        sb.append(':').append(this.type);
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.groupId);
        hash = 17 * hash + Objects.hashCode(this.artifactId);
        hash = 17 * hash + Objects.hashCode(this.classifier);
        hash = 17 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIdentifier other = (ArtifactIdentifier)obj;
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    public static final class GroupIdBuilderStage {
        private GroupIdBuilderStage() {
        }

        public ArtifactIdBuilderStage groupId(String groupId) {
            return new ArtifactIdBuilderStage(Objects.requireNonNull(groupId));
        }
    }

    public static final class FinalBuilderStage {
        private final String groupId;
        private final String artifactId;
        private final Optional<String> classifier;
        private final String type;

        private FinalBuilderStage(String groupId, String artifactId, Optional<String> classifier, String type) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.type = type;
        }

        public ArtifactIdentifier build() {
            return new ArtifactIdentifier(this.groupId, this.artifactId, this.classifier, this.type);
        }
    }

    public static final class TypeBuilderStage {
        private final String groupId;
        private final String artifactId;
        private final Optional<String> classifier;

        private TypeBuilderStage(String groupId, String artifactId, Optional<String> classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
        }

        public FinalBuilderStage type(String type) {
            return new FinalBuilderStage(this.groupId, this.artifactId, this.classifier, Optional.of(type).orElse(ArtifactIdentifier.DEFAULT_TYPE));
        }

        public FinalBuilderStage type(Optional<String> possiblyType) {
            return new FinalBuilderStage(this.groupId, this.artifactId, this.classifier, Objects.requireNonNull(possiblyType).orElse(ArtifactIdentifier.DEFAULT_TYPE));
        }

        public ArtifactIdentifier build() {
            return new ArtifactIdentifier(this.groupId, this.artifactId, this.classifier, ArtifactIdentifier.DEFAULT_TYPE);
        }
    }

    public static final class ClassifierBuilderStage {
        private final String groupId;
        private final String artifactId;

        private ClassifierBuilderStage(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public TypeBuilderStage classifier(String classifier) {
            return new TypeBuilderStage(this.groupId, this.artifactId, Optional.of(classifier));
        }

        public TypeBuilderStage classifier(Optional<String> possiblyClassifier) {
            return new TypeBuilderStage(this.groupId, this.artifactId, Objects.requireNonNull(possiblyClassifier));
        }

        public FinalBuilderStage type(String type) {
            return new TypeBuilderStage(this.groupId, this.artifactId, Optional.empty()).type(type);
        }

        public FinalBuilderStage type(Optional<String> possiblyType) {
            return new TypeBuilderStage(this.groupId, this.artifactId, Optional.empty()).type(possiblyType);
        }

        public ArtifactIdentifier build() {
            return new ArtifactIdentifier(this.groupId, this.artifactId, Optional.empty(), ArtifactIdentifier.DEFAULT_TYPE);
        }
    }

    public static final class ArtifactIdBuilderStage {
        private final String groupId;

        private ArtifactIdBuilderStage(String groupId) {
            this.groupId = groupId;
        }

        public ClassifierBuilderStage artifactId(String artifactId) {
            return new ClassifierBuilderStage(this.groupId, Objects.requireNonNull(artifactId));
        }
    }
}

