/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public final class LockerPomFileAccessor {
    public final File file;

    private LockerPomFileAccessor(File file) {
        this.file = file;
    }

    public static LockerPomFileAccessor fromBasedir(File basedir, String filename) {
        return new LockerPomFileAccessor(new File(basedir, filename));
    }

    public Reader reader() {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Writer writer() {
        this.file.getParentFile().mkdirs();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String filename() {
        return this.file.getAbsolutePath();
    }
}

