/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.pom;

import com.ctc.wstx.stax.WstxInputFactory;
import io.mvnpm.maven.locker.model.Artifact;
import io.mvnpm.maven.locker.model.ArtifactIdentifier;
import io.mvnpm.maven.locker.pom.InvalidPomLockFileException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;

public final class LockerPomReader {
    private static final String POM_NS = "http://maven.apache.org/POM/4.0.0";
    private static final String DEPENDENCY_LOCK_NS = "urn:se.vandmo.dependencylock";
    private static final QName PROJECT = new QName("http://maven.apache.org/POM/4.0.0", "project");
    private static final QName DEPENDENCY_MANAGEMENT = new QName("http://maven.apache.org/POM/4.0.0", "dependencyManagement");
    private static final QName DEPENDENCIES = new QName("http://maven.apache.org/POM/4.0.0", "dependencies");
    private static final QName DEPENDENCY = new QName("http://maven.apache.org/POM/4.0.0", "dependency");
    private static final QName PROPERTIES = new QName("http://maven.apache.org/POM/4.0.0", "properties");
    private static final QName GROUP_ID = new QName("http://maven.apache.org/POM/4.0.0", "groupId");
    private static final QName ARTIFACT_ID = new QName("http://maven.apache.org/POM/4.0.0", "artifactId");
    private static final QName VERSION = new QName("http://maven.apache.org/POM/4.0.0", "version");
    private static final QName TYPE = new QName("http://maven.apache.org/POM/4.0.0", "type");
    private static final QName SCOPE = new QName("http://maven.apache.org/POM/4.0.0", "scope");
    private static final QName CLASSIFIER = new QName("http://maven.apache.org/POM/4.0.0", "classifier");
    private static final QName OPTIONAL = new QName("http://maven.apache.org/POM/4.0.0", "optional");
    private static final QName INTEGRITY = new QName("urn:se.vandmo.dependencylock", "integrity");
    private static final String LOCK_INTEGRITY_PROP_PREFIX = "lock-integrity-";

    public static List<Artifact> read(File file) {
        try {
            return LockerPomReader.doRead(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (XMLStreamException e) {
            throw new InvalidPomLockFileException(e);
        }
    }

    private static List<Artifact> doRead(File file) throws IOException, XMLStreamException {
        WstxInputFactory inputFactory = LockerPomReader.createInputFactory();
        XMLEventReader2 reader = inputFactory.createXMLEventReader(file);
        while (reader.hasNextEvent()) {
            XMLEvent evt = reader.nextEvent();
            if (!evt.isStartElement()) continue;
            QName name = evt.asStartElement().getName();
            if (!name.equals(PROJECT)) {
                throw new InvalidPomLockFileException("Expected 'project'-element", evt.getLocation());
            }
            return LockerPomReader.fromProject(reader);
        }
        throw new InvalidPomLockFileException("Ended prematurely");
    }

    private static WstxInputFactory createInputFactory() {
        WstxInputFactory inputFactory = new WstxInputFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", (Object)false);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", (Object)true);
        inputFactory.setProperty("javax.xml.stream.isValidating", (Object)false);
        return inputFactory;
    }

    private static List<Artifact> fromProject(XMLEventReader2 reader) throws XMLStreamException {
        AtomicReference<Map<String, String>> integrityMap = new AtomicReference<Map<String, String>>();
        AtomicReference deps = new AtomicReference();
        while (reader.hasNextEvent()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            QName name = event.asStartElement().getName();
            if (name.equals(DEPENDENCY_MANAGEMENT)) {
                LockerPomReader.fromElement(reader, DEPENDENCIES, r1 -> deps.set(LockerPomReader.fromDependencies(reader)));
                continue;
            }
            if (name.equals(PROPERTIES)) {
                integrityMap.set(LockerPomReader.extractIntegrityMap(reader));
                continue;
            }
            if (integrityMap.get() != null && deps.get() != null) break;
            LockerPomReader.skipElement(reader);
        }
        if (deps.get() == null) {
            throw new InvalidPomLockFileException("Missing 'dependencyManagement' element");
        }
        if (integrityMap.get() == null) {
            throw new InvalidPomLockFileException("Missing 'properties' element for integrity");
        }
        return ((List)deps.get()).stream().map(d -> LockerPomReader.buildArtifact(d, (Map)integrityMap.get())).collect(Collectors.toList());
    }

    private static Artifact buildArtifact(Artifact.IntegrityBuilderStage d, Map<String, String> finalIntegrityMap) {
        if (!finalIntegrityMap.containsKey(d.artifactIdentifier.key())) {
            throw new InvalidPomLockFileException("Missing integrity property for: " + d.artifactIdentifier.key());
        }
        return d.integrity(finalIntegrityMap.get(d.artifactIdentifier.key())).build();
    }

    private static void fromElement(XMLEventReader2 rdr, QName name, Consumer<XMLEventReader2> onElement) {
        try {
            while (rdr.hasNextEvent()) {
                XMLEvent evt = null;
                evt = rdr.nextEvent();
                if (!evt.isStartElement()) continue;
                QName elName = evt.asStartElement().getName();
                if (elName.equals(name)) {
                    onElement.accept(rdr);
                    break;
                }
                LockerPomReader.skipElement(rdr);
            }
        }
        catch (XMLStreamException e) {
            throw new InvalidPomLockFileException(e);
        }
    }

    private static List<Artifact.IntegrityBuilderStage> fromDependencies(XMLEventReader2 rdr) {
        try {
            ArrayList<Artifact.IntegrityBuilderStage> result = new ArrayList<Artifact.IntegrityBuilderStage>();
            while (rdr.hasNextEvent()) {
                XMLEvent evt = rdr.nextEvent();
                if (evt.isStartElement()) {
                    QName name = evt.asStartElement().getName();
                    if (name.equals(DEPENDENCY)) {
                        result.add(LockerPomReader.fromDependency(rdr));
                        continue;
                    }
                    LockerPomReader.skipElement(rdr);
                    continue;
                }
                if (!evt.isEndElement()) continue;
                if (evt.asEndElement().getName().equals(DEPENDENCIES)) break;
                throw new InvalidPomLockFileException("Expected '</dependencies>'", evt.getLocation());
            }
            return result;
        }
        catch (XMLStreamException e) {
            throw new InvalidPomLockFileException(e);
        }
    }

    private static Map<String, String> extractIntegrityMap(XMLEventReader2 reader) throws XMLStreamException {
        HashMap<String, String> integrityMap = new HashMap<String, String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().startsWith(LOCK_INTEGRITY_PROP_PREFIX)) {
                String name = event.asStartElement().getName().getLocalPart();
                String value = LockerPomReader.readSingleTextElement(reader);
                String key = name.substring(LOCK_INTEGRITY_PROP_PREFIX.length());
                integrityMap.put(key, value);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(PROPERTIES)) continue;
            break;
        }
        return integrityMap;
    }

    private static Artifact.IntegrityBuilderStage fromDependency(XMLEventReader2 rdr) {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String type = null;
        String scope = null;
        String classifier = null;
        Boolean optional = null;
        try {
            while (rdr.hasNextEvent()) {
                XMLEvent event = rdr.nextEvent();
                if (event.isStartElement()) {
                    Location startElementLocation = event.getLocation();
                    QName name = event.asStartElement().getName();
                    if (name.equals(GROUP_ID)) {
                        groupId = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(ARTIFACT_ID)) {
                        artifactId = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(VERSION)) {
                        version = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(TYPE)) {
                        type = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(SCOPE)) {
                        scope = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(CLASSIFIER)) {
                        classifier = LockerPomReader.readSingleTextElement(rdr);
                        continue;
                    }
                    if (name.equals(OPTIONAL)) {
                        String optionalStr;
                        switch (optionalStr = LockerPomReader.readSingleTextElement(rdr)) {
                            case "false": {
                                optional = false;
                                break;
                            }
                            case "true": {
                                optional = true;
                                break;
                            }
                            default: {
                                throw new InvalidPomLockFileException(String.format(Locale.ROOT, "Invalid optional value '%s' for dependency", optionalStr), startElementLocation);
                            }
                        }
                        continue;
                    }
                    LockerPomReader.skipElement(rdr);
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (!event.asEndElement().getName().equals(DEPENDENCY)) {
                    throw new InvalidPomLockFileException("Expected '</dependency>'", event.getLocation());
                }
                if (groupId == null) {
                    throw new InvalidPomLockFileException("Missing groupId", event.getLocation());
                }
                if (artifactId == null) {
                    throw new InvalidPomLockFileException("Missing artifactId", event.getLocation());
                }
                if (version == null) {
                    throw new InvalidPomLockFileException("Missing version", event.getLocation());
                }
                if (type == null) {
                    type = "jar";
                }
                if (scope == null) {
                    scope = "compile";
                }
                if (optional == null) {
                    optional = false;
                }
                return Artifact.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(groupId).artifactId(artifactId).classifier(Optional.ofNullable(classifier)).type(type).build()).version(version).scope(scope).optional(optional);
            }
        }
        catch (XMLStreamException e) {
            throw new InvalidPomLockFileException(e);
        }
        throw new InvalidPomLockFileException("Ended prematurely");
    }

    private static String readSingleTextElement(XMLEventReader2 reader) throws XMLStreamException {
        XMLEvent characterEvent = LockerPomReader.expectEvent(reader);
        if (!characterEvent.isCharacters()) {
            throw new InvalidPomLockFileException("Expected characters", characterEvent.getLocation());
        }
        String content = characterEvent.asCharacters().getData();
        XMLEvent endElementEvent = LockerPomReader.expectEvent(reader);
        if (!endElementEvent.isEndElement()) {
            throw new InvalidPomLockFileException("Expected end of text element", endElementEvent.getLocation());
        }
        return content;
    }

    private static XMLEvent expectEvent(XMLEventReader2 reader) throws XMLStreamException {
        if (!reader.hasNextEvent()) {
            throw new InvalidPomLockFileException("Ended prematurely");
        }
        return reader.nextEvent();
    }

    private static void skipElement(XMLEventReader2 reader) throws XMLStreamException {
        int level = 0;
        while (reader.hasNextEvent() && level >= 0) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                ++level;
                continue;
            }
            if (!event.isEndElement()) continue;
            --level;
        }
    }
}

