/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.mojos;

import com.google.common.io.Resources;
import io.fabric8.maven.Maven;
import io.fabric8.maven.merge.SmartModelMerger;
import io.mvnpm.maven.locker.model.GAV;
import io.mvnpm.maven.locker.model.ParentPom;
import io.mvnpm.maven.locker.mojos.AbstractDependencyLockMojo;
import io.mvnpm.maven.locker.pom.DefaultLockerPom;
import io.mvnpm.maven.locker.pom.LockerPom;
import io.mvnpm.maven.locker.pom.LockerPomFileAccessor;
import io.quarkus.qute.Qute;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="lock", requiresDependencyResolution=ResolutionScope.TEST)
public final class LockMojo
extends AbstractDependencyLockMojo {
    @Parameter(property="locker.filter", defaultValue="org.mvnpm*,org.webjars*")
    private List<String> filters;

    public void execute() throws MojoExecutionException {
        if (this.project.getActiveProfiles().stream().map(Profile::getId).anyMatch("locker"::equals)) {
            throw new MojoExecutionException("Locking is not possible with 'locker' profile enabled. Use '-P\\!locker' when locking or add the 'locker-maven-plugin' extension to '.mvn/extensions.xml'.");
        }
        LockerPomFileAccessor lockFile = this.lockFile();
        ParentPom parentPom = this.getParentPom(lockFile.file);
        if (lockFile.exists()) {
            this.getLog().info((CharSequence)String.format(Locale.ROOT, "Updating %s", lockFile.absolutePath()));
        } else {
            this.getLog().info((CharSequence)String.format(Locale.ROOT, "Creating %s", lockFile.absolutePath()));
        }
        LockerPom lockerPom = DefaultLockerPom.from(lockFile, this.pomMinimums(), this.getLog());
        lockerPom.write(parentPom, this.projectDependencies().filter(this.filters));
        Model model = this.project.getModel();
        Optional<Profile> existingLockerProfile = model.getProfiles().stream().filter(p -> p.getId().equals("locker")).findFirst();
        boolean hasActiveByDefaultProfiles = model.getProfiles().stream().anyMatch(p -> p.getActivation().isActiveByDefault());
        if (hasActiveByDefaultProfiles) {
            this.getLog().warn((CharSequence)"\n\nThe locker profile uses a NEGATED PROPERTY '!unlocked'. This OVERRIDES the 'activeByDefault' option in other profiles.\n\nYour pom.xml contains profiles with 'activeByDefault=true'.\nFor CONSISTENT BEHAVIOR, consider REMOVING 'activeByDefault=true' from your profiles or use NEGATED PROPERTIES instead.\n\n");
        }
        if (existingLockerProfile.isEmpty()) {
            this.getLog().info((CharSequence)"Adding 'locker' profile to the pom.xml...");
            this.addProfileToPom();
        } else {
            this.getLog().info((CharSequence)"'locker' profile is present in the pom.xml");
        }
    }

    private ParentPom getParentPom(Path lockerPom) {
        String relativeParentPath;
        if (this.project.getParent() != null && (relativeParentPath = this.getRelativeParentPath(lockerPom)) != null) {
            return new ParentPom(GAV.from(this.project.getParent()), relativeParentPath);
        }
        return null;
    }

    public String getRelativeParentPath(Path lockerPom) {
        Path parentPath = this.project.getParent().getFile().toPath().toAbsolutePath();
        Path parentDirPath = parentPath.getParent();
        if (lockerPom.startsWith(parentDirPath)) {
            return lockerPom.getParent().relativize(parentPath).toString();
        }
        return null;
    }

    private void addProfileToPom() throws MojoExecutionException {
        Model locker;
        Model model = Maven.readModel((Path)this.project.getFile().toPath());
        try {
            String content = this.getLockerProfile();
            locker = Maven.readModel((Reader)new StringReader(content));
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        SmartModelMerger merger = new SmartModelMerger();
        merger.merge(model, locker, false, Map.of());
        Maven.writeModel((Model)model);
    }

    private String getLockerProfile() throws IOException {
        String tpl = Resources.toString((URL)Resources.getResource(LockMojo.class, (String)"locker-profile.xml"), (Charset)StandardCharsets.UTF_8);
        Map<String, String> data = Map.of("useNegatedProp", true, "lockerProfile", "locker", "groupId", this.project.getGroupId(), "artifactId", this.project.getArtifactId());
        return Qute.fmt((String)tpl, data);
    }
}

