/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.pom;

import com.google.common.io.Resources;
import io.mvnpm.maven.locker.model.Artifacts;
import io.mvnpm.maven.locker.model.GAV;
import io.mvnpm.maven.locker.model.ParentPom;
import io.mvnpm.maven.locker.pom.LockerPom;
import io.mvnpm.maven.locker.pom.LockerPomFileAccessor;
import io.mvnpm.maven.locker.pom.LockerPomReader;
import io.quarkus.qute.Qute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;

public final class DefaultLockerPom
implements LockerPom {
    private final LockerPomFileAccessor lockerPom;
    private final GAV gav;
    private final Log log;

    private DefaultLockerPom(LockerPomFileAccessor lockerPom, GAV gav, Log log) {
        this.lockerPom = lockerPom;
        this.gav = gav;
        this.log = log;
    }

    public static LockerPom from(LockerPomFileAccessor dependenciesLockFile, GAV gav, Log log) {
        return new DefaultLockerPom(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(gav), Objects.requireNonNull(log));
    }

    @Override
    public void write(ParentPom parent, Artifacts artifacts) {
        try {
            URL url = Resources.getResource(this.getClass(), (String)"pom.xml");
            String template = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            String fmted = Qute.fmt((String)template, DefaultLockerPom.makeDataModel(this.gav, parent, artifacts));
            try (Writer writer = this.lockerPom.writer();){
                writer.write(fmted);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<String, Object> makeDataModel(GAV gav, ParentPom parent, Artifacts artifacts) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("pom", gav);
        dataModel.put("dependencies", artifacts);
        dataModel.put("parent", parent);
        return dataModel;
    }

    @Override
    public Artifacts read() {
        return Artifacts.fromArtifacts(LockerPomReader.read(this.lockerPom.file));
    }
}

