/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.pom;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class LockerPomFileAccessor {
    public final Path file;

    private LockerPomFileAccessor(Path file) {
        this.file = file;
    }

    public static LockerPomFileAccessor fromBasedir(Path basedir, String filename) {
        return new LockerPomFileAccessor(basedir.resolve(filename));
    }

    public Reader reader() {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(this.file.toFile()), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Writer writer() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file.toFile()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    public String absolutePath() {
        return this.file.toAbsolutePath().toString();
    }
}

