/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.common.core;

import io.mybatis.common.core.Code;
import io.mybatis.common.exception.ServiceException;
import io.mybatis.common.util.I18n;

public class Response<T extends Response> {
    public static final String RESPONSE_BUNDLE = "mybatis_common_response";
    protected boolean success;
    protected String code;
    protected String message;

    public static Response ok() {
        Response response = new Response();
        response.success = true;
        response.code = Code.SUCCESS.getCode();
        return response;
    }

    public static Response error() {
        return Response.error(Code.UNKNOWN);
    }

    public static Response error(String code) {
        return Response.error(code, I18n.message(RESPONSE_BUNDLE, code, new Object[0]));
    }

    public static Response error(Throwable t) {
        return Response.error(Code.UNKNOWN.getCode(), t.getMessage());
    }

    public static Response error(ServiceException e) {
        return Response.error(e.getCode());
    }

    public static Response error(String code, String message) {
        Response response = new Response();
        response.success = false;
        response.code = code;
        response.message = message;
        return response;
    }

    public static Response error(Code code) {
        return Response.error(code.getCode(), code.getMessage());
    }

    public T code(String code) {
        this.code = code;
        return (T)this;
    }

    public T message(String message) {
        this.message = message;
        return (T)this;
    }

    public T success(boolean success) {
        this.success = success;
        return (T)this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

