/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.common.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    public static String message(Locale locale, String bundleName, String key, Object ... args) {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (Exception e) {
            bundle = null;
        }
        try {
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (MissingResourceException e) {
            return MessageFormat.format(key, args);
        }
    }

    public static String message(String bundleName, String key, Object ... args) {
        return I18n.message(Locale.getDefault(), bundleName, key, args);
    }

    public static Language language(Locale locale, String bundleName) {
        return (key, args) -> I18n.message(locale, bundleName, key, args);
    }

    public static Language language(String bundleName) {
        return I18n.language(Locale.getDefault(), bundleName);
    }

    public static interface Language {
        public String message(String var1, Object ... var2);
    }
}

