/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.config.defaults;

import io.mybatis.config.Config;
import io.mybatis.config.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserConfig
implements Config {
    public static final Logger log = LoggerFactory.getLogger(UserConfig.class);
    public static final String FILE_TYPE = ".properties";
    protected volatile Properties properties;

    @Override
    public int getOrder() {
        return 200;
    }

    protected abstract String getConfigKey();

    protected abstract String getConfigName();

    protected boolean skipKey(String key) {
        return this.getConfigKey().equals(key);
    }

    protected void init() {
        Properties props = this.getUserProperties();
        this.properties = props != null ? props : new Properties();
    }

    protected Properties getUserProperties() {
        File file;
        String propFileName;
        String requestedFile = System.getProperty(this.getConfigKey());
        String string = propFileName = requestedFile != null ? requestedFile : this.getConfigName();
        if (!propFileName.endsWith(FILE_TYPE)) {
            propFileName = propFileName + FILE_TYPE;
        }
        if (!(file = new File(propFileName)).exists()) {
            if (requestedFile != null) {
                try {
                    file = ResourceUtil.getFile(requestedFile);
                }
                catch (FileNotFoundException e) {
                    log.warn("\u6307\u5b9a\u7684\u7528\u6237\u914d\u7f6e\u6587\u4ef6: " + requestedFile + " \u4e0d\u5b58\u5728");
                }
                try {
                    file = ResourceUtil.getClasspathFile(requestedFile);
                }
                catch (FileNotFoundException e) {
                    log.warn("\u6307\u5b9a\u7684\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u5728\u7c7b\u8def\u5f84\u4e0b: " + requestedFile + " \u4e0d\u5b58\u5728");
                }
            } else {
                try {
                    file = ResourceUtil.getClasspathFile(propFileName);
                }
                catch (FileNotFoundException e) {
                    try {
                        file = ResourceUtil.getClasspathFile("/" + propFileName);
                    }
                    catch (FileNotFoundException e2) {
                        try {
                            String path = this.getClass().getPackage().getName().replaceAll("\\.", "/");
                            file = ResourceUtil.getClasspathFile(path + "/" + propFileName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        Properties props = new Properties();
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                props.load(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStr(String key) {
        if (this.skipKey(key)) {
            return null;
        }
        if (this.properties == null) {
            UserConfig userConfig = this;
            synchronized (userConfig) {
                if (this.properties == null) {
                    this.init();
                }
            }
        }
        return this.properties.getProperty(key);
    }
}

