/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.config.defaults;

import io.mybatis.config.Config;
import io.mybatis.config.ConfigHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public abstract class VersionConfig
implements Config {
    public static final String FILE_TYPE = ".properties";
    protected volatile Properties properties;

    @Override
    public int getOrder() {
        return 100;
    }

    protected abstract String getConfigName();

    protected abstract String getVersionKey();

    protected String getConfigPath() {
        return this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/";
    }

    protected boolean skipKey(String key) {
        return this.getVersionKey().equals(key);
    }

    protected void init() {
        Properties props = this.buildVersionProperties();
        this.properties = props != null ? props : new Properties();
    }

    private List<ConfigVersion> sortVersions(Collection<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile(this.getConfigName() + "-(v\\d+\\.\\d+)\\" + FILE_TYPE);
        return fileNames.stream().map(fileName -> {
            Matcher matcher = pattern.matcher((CharSequence)fileName);
            if (matcher.find()) {
                return new ConfigVersion(matcher.group(1), (String)fileName);
            }
            return null;
        }).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    private ConfigVersion chooseVersion(List<ConfigVersion> versions, String version) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        if (version == null || version.isEmpty()) {
            return versions.get(versions.size() - 1);
        }
        ConfigVersion configVersion = new ConfigVersion(version);
        for (int i = versions.size() - 1; i >= 0; --i) {
            if (configVersion.compareTo(versions.get(i)) < 0) continue;
            return versions.get(i);
        }
        return versions.get(0);
    }

    private Properties build(List<ConfigVersion> versions, ConfigVersion chooseVersion, Function<ConfigVersion, InputStream> toInputStream) throws IOException {
        InputStream is;
        if (chooseVersion == null) {
            return null;
        }
        Properties prop = null;
        for (ConfigVersion configVersion : versions) {
            if (configVersion == chooseVersion) continue;
            prop = new Properties(prop);
            is = toInputStream.apply(configVersion);
            if (is == null) continue;
            prop.load(is);
            is.close();
        }
        prop = new Properties(prop);
        is = toInputStream.apply(chooseVersion);
        if (is != null) {
            prop.load(is);
            is.close();
        }
        return prop;
    }

    private Properties chooseFromJarFile(JarFile jarFile, String version) throws IOException {
        String configName = this.getConfigName();
        String configPath = this.getConfigPath();
        Enumeration<JarEntry> entries = jarFile.entries();
        HashMap<String, JarEntry> entryMap = new HashMap<String, JarEntry>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(configPath) || !(name = name.substring(configPath.length())).startsWith(configName)) continue;
            entryMap.put(name, entry);
        }
        List<ConfigVersion> versions = this.sortVersions(new ArrayList<String>(entryMap.keySet()));
        ConfigVersion chooseVersion = this.chooseVersion(versions, version);
        return this.build(versions, chooseVersion, configVersion -> {
            try {
                return jarFile.getInputStream((ZipEntry)entryMap.get(chooseVersion.getFileName()));
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    private Properties chooseFromFile(File file, String version) throws IOException {
        String configName = this.getConfigName();
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (File f : files) {
            if (!f.getName().startsWith(configName)) continue;
            fileMap.put(f.getName(), f);
        }
        List<ConfigVersion> versions = this.sortVersions(new ArrayList<String>(fileMap.keySet()));
        ConfigVersion chooseVersion = this.chooseVersion(versions, version);
        return this.build(versions, chooseVersion, configVersion -> {
            try {
                return new FileInputStream((File)fileMap.get(configVersion.getFileName()));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        });
    }

    protected Properties buildVersionProperties() {
        String version = ConfigHelper.getStr(this.getVersionKey());
        URL resource = this.getClass().getResource("");
        if (resource == null) {
            return null;
        }
        if (resource.getProtocol().equals("file")) {
            if (resource.getPath().endsWith(".jar")) {
                try {
                    JarFile jarFile = new JarFile(resource.getPath());
                    return this.chooseFromJarFile(jarFile, version);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                File file = new File(resource.toURI());
                return this.chooseFromFile(file, version);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarFile jarFile = ((JarURLConnection)resource.openConnection()).getJarFile();
                return this.chooseFromJarFile(jarFile, version);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStr(String key) {
        if (this.skipKey(key)) {
            return null;
        }
        if (this.properties == null) {
            VersionConfig versionConfig = this;
            synchronized (versionConfig) {
                if (this.properties == null) {
                    this.init();
                }
            }
        }
        return this.properties.getProperty(key);
    }

    public static class ConfigVersion
    implements Comparable<ConfigVersion> {
        private final int x;
        private final int y;
        private final String fileName;

        public ConfigVersion(String version) {
            this(version, null);
        }

        public ConfigVersion(String version, String fileName) {
            this.fileName = fileName;
            if (version.startsWith("v")) {
                version = version.substring(1);
            }
            String[] strings = version.split("\\.");
            this.x = Integer.parseInt(strings[0]);
            this.y = Integer.parseInt(strings[1]);
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public int compareTo(ConfigVersion o) {
            if (this.x == o.x) {
                return this.y - o.y;
            }
            return this.x - o.x;
        }
    }
}

