/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.mapper.logical;

import io.mybatis.common.util.Assert;
import io.mybatis.mapper.logical.LogicalColumn;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.SqlScript;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.annotation.ProviderContext;

public class LogicalProvider {
    public static String select(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.table() + this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity)) + entity.groupByColumn().orElse("") + entity.havingColumn().orElse("") + entity.orderByColumn().orElse("");
            }
        });
    }

    public static String selectColumns(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "SELECT " + this.choose(() -> this.whenTest("fns != null and fns.isNotEmpty()", () -> "${fns.baseColumnAsPropertyList()}") + this.otherwise(() -> entity.baseColumnAsPropertyList())) + " FROM " + entity.tableName() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest("entity."), () -> "AND " + column.columnEqualsProperty("entity."))).collect(Collectors.joining("\n")))) + this.logicalNotEqualCondition(entity)) + entity.groupByColumn().orElse("") + entity.havingColumn().orElse("") + entity.orderByColumn().orElse("");
            }
        });
    }

    public static String selectByExample(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return this.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "SELECT " + this.ifTest("distinct", () -> "distinct ") + this.ifTest("selectColumns != null and selectColumns != ''", () -> "${selectColumns}") + this.ifTest("selectColumns == null or selectColumns == ''", () -> ((EntityTable)entity).baseColumnAsPropertyList()) + " FROM " + entity.table() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n") + this.logicalNotEqualCondition(entity)) + this.ifTest("orderByClause != null", () -> " ORDER BY ${orderByClause}") + this.ifTest("orderByClause == null", () -> entity.orderByColumn().orElse("")) + this.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
            }
        });
    }

    public static String countByExample(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return this.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "SELECT COUNT(" + this.ifTest("distinct", () -> "distinct ") + this.ifTest("simpleSelectColumns != null and simpleSelectColumns != ''", () -> "${simpleSelectColumns}") + this.ifTest("simpleSelectColumns == null or simpleSelectColumns == ''", () -> "*") + ") FROM " + entity.table() + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> this.ifParameterNotNull(() -> "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n") + this.logicalNotEqualCondition(entity)) + this.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
            }
        });
    }

    public static String selectByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "SELECT " + entity.baseColumnAsPropertyList() + " FROM " + entity.table() + this.where(() -> entity.idColumns().stream().map(EntityColumn::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String selectCount(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "SELECT COUNT(*)  FROM " + entity.table() + "\n" + this.where(() -> entity.whereColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity));
            }
        });
    }

    public static String updateByExample(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return this.ifTest("example.startSql != null and example.startSql != ''", () -> "${example.startSql}") + "UPDATE " + entity.tableName() + this.set(() -> entity.updateColumns().stream().map(column -> column.columnEqualsProperty("entity.")).collect(Collectors.joining(","))) + this.variableNotNull("example", "Example cannot be null") + (entity.getPropBoolean("updateByExample.allowEmpty", Boolean.valueOf(true)) != false ? "" : this.variableIsFalse("example.isEmpty()", "Example Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"example.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("example.endSql != null and example.endSql != ''", () -> "${example.endSql}");
            }
        });
    }

    public static String updateByExampleSelective(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return this.ifTest("example.startSql != null and example.startSql != ''", () -> "${example.startSql}") + "UPDATE " + entity.table() + this.set(() -> entity.updateColumns().stream().map(column -> this.ifTest(column.notNullTest("entity."), () -> column.columnEqualsProperty("entity.") + ",")).collect(Collectors.joining("\n"))) + this.variableNotNull("example", "Example cannot be null") + (entity.getPropBoolean("updateByExampleSelective.allowEmpty", Boolean.valueOf(true)) != false ? "" : this.variableIsFalse("example.isEmpty()", "Example Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"example.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("example.endSql != null and example.endSql != ''", () -> "${example.endSql}");
            }
        });
    }

    public static String updateByExampleSetValues(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return this.ifTest("example.startSql != null and example.startSql != ''", () -> "${example.startSql}") + this.variableNotEmpty("example.setValues", "Example setValues cannot be empty") + "UPDATE " + entity.table() + "<set>  <foreach collection=\"example.setValues\" item=\"setValue\">\n    <choose>\n      <when test=\"setValue.noValue\">\n        ${setValue.condition},\n      </when>\n      <when test=\"setValue.singleValue\">\n        ${setValue.condition} = #{setValue.value},\n      </when>\n    </choose>\n  </foreach>\n</set>" + this.variableNotNull("example", "Example cannot be null") + (entity.getPropBoolean("updateByExample.allowEmpty", Boolean.valueOf(true)) != false ? "" : this.variableIsFalse("example.isEmpty()", "Example Criteria cannot be empty")) + this.trim("WHERE", "", "WHERE |OR |AND ", "", () -> "<where>\n  <foreach collection=\"example.oredCriteria\" item=\"criteria\"\n separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + this.logicalNotEqualCondition(entity)) + this.ifTest("example.endSql != null and example.endSql != ''", () -> "${example.endSql}");
            }
        });
    }

    public static String updateByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "UPDATE " + entity.table() + " SET " + entity.updateColumns().stream().map(EntityColumn::columnEqualsProperty).collect(Collectors.joining(",")) + this.where(() -> entity.idColumns().stream().map(EntityColumn::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String updateByPrimaryKeySelective(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "UPDATE " + entity.table() + this.set(() -> entity.updateColumns().stream().map(column -> this.ifTest(column.notNullTest(), () -> column.columnEqualsProperty() + ",")).collect(Collectors.joining("\n"))) + this.where(() -> entity.idColumns().stream().map(EntityColumn::columnEqualsProperty).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String updateByPrimaryKeySelectiveWithForceFields(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                return "UPDATE " + entity.table() + this.set(() -> entity.updateColumns().stream().map(column -> this.choose(() -> this.whenTest("fns != null and fns.fieldNames().contains('" + column.property() + "')", () -> column.columnEqualsProperty("entity.") + ",") + this.whenTest(column.notNullTest("entity."), () -> column.columnEqualsProperty("entity.") + ","))).collect(Collectors.joining("\n"))) + this.where(() -> entity.idColumns().stream().map(column -> column.columnEqualsProperty("entity.")).collect(Collectors.joining(" AND "))) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String delete(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                EntityColumn logicColumn = LogicalProvider.getLogicalColumn(entity);
                return "UPDATE " + entity.table() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + this.parameterNotNull("Parameter cannot be null") + this.where(() -> entity.columns().stream().map(column -> this.ifTest(column.notNullTest(), () -> "AND " + column.columnEqualsProperty())).collect(Collectors.joining("\n")) + this.logicalNotEqualCondition(entity));
            }
        });
    }

    public static String deleteByPrimaryKey(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (SqlScript)new LogicalSqlScript(){

            public String getSql(EntityTable entity) {
                EntityColumn logicColumn = LogicalProvider.getLogicalColumn(entity);
                return "UPDATE " + entity.table() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + " WHERE " + entity.idColumns().stream().map(EntityColumn::columnEqualsProperty).collect(Collectors.joining(" AND ")) + this.logicalNotEqualCondition(entity);
            }
        });
    }

    public static String deleteByExample(ProviderContext providerContext) {
        return SqlScript.caching((ProviderContext)providerContext, (entity, util) -> {
            EntityColumn logicColumn = LogicalProvider.getLogicalColumn(entity);
            return util.ifTest("startSql != null and startSql != ''", () -> "${startSql}") + "UPDATE " + entity.table() + " SET " + LogicalProvider.columnEqualsValue(logicColumn, LogicalProvider.deleteValue(logicColumn)) + util.parameterNotNull("Example cannot be null") + (entity.getPropBoolean("deleteByExample.allowEmpty", Boolean.valueOf(true)) != false ? "" : util.variableIsFalse("_parameter.isEmpty()", "Example Criteria cannot be empty")) + "<where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" OR \">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n            <when test=\"criterion.orValue\">\n              <foreach collection=\"criterion.value\" item=\"orCriteria\" separator=\" OR \" open = \" AND (\" close = \")\">\n                <if test=\"orCriteria.valid\">\n                  <trim prefix=\"(\" prefixOverrides=\"AND\" suffix=\")\">\n                    <foreach collection=\"orCriteria.criteria\" item=\"criterion\">\n                      <choose>\n            <when test=\"criterion.noValue\">\n              AND ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              AND ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              AND ${criterion.condition} #{criterion.value} AND\n              #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              AND ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\"\n                open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n                      </choose>\n                    </foreach>\n                  </trim>\n                </if>\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>\n" + " AND " + LogicalProvider.columnNotEqualsValueCondition(logicColumn, LogicalProvider.deleteValue(logicColumn)) + util.ifTest("endSql != null and endSql != ''", () -> "${endSql}");
        });
    }

    private static EntityColumn getLogicalColumn(EntityTable entity) {
        List logicColumns = entity.columns().stream().filter(c -> c.field().isAnnotationPresent(LogicalColumn.class)).collect(Collectors.toList());
        Assert.isTrue((logicColumns.size() == 1 ? 1 : 0) != 0, (String)"There are no or multiple fields marked with @LogicalColumn");
        return (EntityColumn)logicColumns.get(0);
    }

    private static String deleteValue(EntityColumn logicColumn) {
        return ((LogicalColumn)logicColumn.field().getAnnotation(LogicalColumn.class)).delete();
    }

    private static String columnEqualsValueCondition(EntityColumn c, String value) {
        return " " + c.column() + LogicalProvider.choiceEqualsOperator(value) + value + " ";
    }

    private static String columnEqualsValue(EntityColumn c, String value) {
        return " " + c.column() + " = " + value + " ";
    }

    private static String columnNotEqualsValueCondition(EntityColumn c, String value) {
        return " " + c.column() + LogicalProvider.choiceNotEqualsOperator(value) + value;
    }

    private static String choiceEqualsOperator(String value) {
        if ("null".compareToIgnoreCase(value) == 0) {
            return " IS ";
        }
        return " = ";
    }

    private static String choiceNotEqualsOperator(String value) {
        if ("null".compareToIgnoreCase(value) == 0) {
            return " IS NOT ";
        }
        return " != ";
    }

    private static interface LogicalSqlScript
    extends SqlScript {
        public static final String EXAMPLE_SET_CLAUSE_INNER_WHEN = "<set>  <foreach collection=\"example.setValues\" item=\"setValue\">\n    <choose>\n      <when test=\"setValue.noValue\">\n        ${setValue.condition},\n      </when>\n      <when test=\"setValue.singleValue\">\n        ${setValue.condition} = #{setValue.value},\n      </when>\n    </choose>\n  </foreach>\n</set>";

        default public String logicalNotEqualCondition(EntityTable entity) {
            EntityColumn logicalColumn = LogicalProvider.getLogicalColumn(entity);
            return " AND " + LogicalProvider.columnNotEqualsValueCondition(logicalColumn, LogicalProvider.deleteValue(logicalColumn)) + "\n";
        }
    }
}

