/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityTable;
import io.mybatis.provider.SqlCache;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;

public class Caching
extends XMLLanguageDriver {
    public static final Log log = LogFactory.getLog(Caching.class);
    private static final Map<String, SqlCache> CACHE_SQL = new ConcurrentHashMap<String, SqlCache>(16);
    private static final Map<Configuration, Map<String, SqlSource>> CONFIGURATION_CACHE_KEY_MAP = new ConcurrentHashMap<Configuration, Map<String, SqlSource>>(1);

    private static String cacheKey(ProviderContext providerContext) {
        return (providerContext.getMapperType().getName() + "." + providerContext.getMapperMethod().getName()).intern();
    }

    private static void isAnnotationPresentLang(ProviderContext providerContext) {
        Lang lang;
        Method mapperMethod = providerContext.getMapperMethod();
        if (mapperMethod.isAnnotationPresent(Lang.class) && (lang = mapperMethod.getAnnotation(Lang.class)).value() == Caching.class) {
            return;
        }
        throw new RuntimeException(mapperMethod + " need to configure @Lang(Caching.class) to use the Caching.cache method for caching");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cache(ProviderContext providerContext, EntityTable entity, Supplier<String> sqlScriptSupplier) {
        String cacheKey = Caching.cacheKey(providerContext);
        if (!CACHE_SQL.containsKey(cacheKey)) {
            Caching.isAnnotationPresentLang(providerContext);
            String string = cacheKey;
            synchronized (string) {
                if (!CACHE_SQL.containsKey(cacheKey)) {
                    CACHE_SQL.put(cacheKey, new SqlCache(providerContext, entity, sqlScriptSupplier));
                }
            }
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (CACHE_SQL.containsKey(script)) {
            String cacheKey = script;
            SqlCache cache = CACHE_SQL.get(cacheKey);
            if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                String string = cacheKey;
                synchronized (string) {
                    if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                        cache.getEntity().initRuntimeContext(configuration, cache.getProviderContext(), cacheKey);
                        Map cachekeyMap = CONFIGURATION_CACHE_KEY_MAP.computeIfAbsent(configuration, k -> new HashMap());
                        String sqlScript = cache.getSqlScript();
                        if (log.isTraceEnabled()) {
                            log.trace("cacheKey - " + cacheKey + " :\n" + sqlScript + "\n");
                        }
                        SqlSource sqlSource = super.createSqlSource(configuration, sqlScript, parameterType);
                        cachekeyMap.put(cacheKey, sqlSource);
                    }
                }
            }
            return CONFIGURATION_CACHE_KEY_MAP.get(configuration).get(cacheKey);
        }
        return super.createSqlSource(configuration, script, parameterType);
    }
}

