/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityFactory;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.defaults.GenericTypeResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface EntityInfoMapper<T> {
    default public Class<T> entityClass() {
        return CachingEntityClass.getEntityClass(this.getClass());
    }

    default public EntityTable entityTable() {
        return EntityFactory.create(this.entityClass());
    }

    public static class CachingEntityClass {
        static Map<Class<?>, Class<?>> entityClassMap = new ConcurrentHashMap();

        private static Class<?> getEntityClass(Class<?> clazz) {
            if (!entityClassMap.containsKey(clazz)) {
                entityClassMap.put(clazz, (Class)GenericTypeResolver.resolveType(EntityInfoMapper.class.getTypeParameters()[0], clazz, EntityInfoMapper.class));
            }
            return entityClassMap.get(clazz);
        }
    }
}

