/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityField;
import io.mybatis.provider.util.ServiceLoaderUtil;
import java.util.List;

public interface NameConvert {
    public static final NameConvert DEFAULT = new NameConvert(){

        public boolean isUppercaseAlpha(char c) {
            return c >= 'A' && c <= 'Z';
        }

        public char toLowerAscii(char c) {
            if (this.isUppercaseAlpha(c)) {
                c = (char)(c + 32);
            }
            return c;
        }

        @Override
        public String convert(String str) {
            char[] chars = str.toCharArray();
            int size = chars.length;
            StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
            for (int i = 0; i < size; ++i) {
                char c = chars[i];
                if (this.isUppercaseAlpha(c)) {
                    sb.append('_').append(this.toLowerAscii(c));
                    continue;
                }
                sb.append(c);
            }
            return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
        }
    };

    public static NameConvert getInstance() {
        return NameConvertInstance.getInstance();
    }

    public String convert(String var1);

    default public String convertEntityClass(Class<?> entityClass) {
        return this.convert(entityClass.getSimpleName());
    }

    default public String convertEntityField(EntityField field) {
        return this.convert(field.getName());
    }

    public static class NameConvertInstance {
        private static volatile NameConvert INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static NameConvert getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<NameConvert> clazz = NameConvert.class;
            synchronized (NameConvert.class) {
                if (INSTANCE != null) return INSTANCE;
                List<NameConvert> instances = ServiceLoaderUtil.getInstances(NameConvert.class);
                INSTANCE = instances.size() > 0 ? instances.get(0) : DEFAULT;
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }
    }
}

