/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.Caching;
import io.mybatis.provider.EntityFactory;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.SqlScriptWrapper;
import java.util.function.Supplier;
import org.apache.ibatis.builder.annotation.ProviderContext;

public interface SqlScript {
    public static final String LF = "\n";

    default public String where(LRSupplier content) {
        return String.format("\n<where>%s\n</where> ", content.getWithLR());
    }

    public static String caching(ProviderContext providerContext, SqlScript sqlScript) {
        EntityTable entity = EntityFactory.create(providerContext.getMapperType(), providerContext.getMapperMethod());
        return Caching.cache(providerContext, entity, () -> String.format("<script>\n%s\n</script>", SqlScriptWrapper.wrapSqlScript(providerContext, entity, sqlScript).getSql(entity)));
    }

    public static String caching(ProviderContext providerContext, SqlScript2 sqlScript) {
        EntityTable entity = EntityFactory.create(providerContext.getMapperType(), providerContext.getMapperMethod());
        return Caching.cache(providerContext, entity, () -> String.format("<script>\n%s\n</script>", SqlScriptWrapper.wrapSqlScript(providerContext, entity, sqlScript).getSql(entity)));
    }

    public String getSql(EntityTable var1);

    default public String choose(LRSupplier content) {
        return String.format("\n<choose>%s\n</choose> ", content.getWithLR());
    }

    default public String otherwise(LRSupplier content) {
        return String.format("\n<otherwise>%s\n</otherwise> ", content.getWithLR());
    }

    default public String set(LRSupplier content) {
        return String.format("\n<set>%s\n</set> ", content.getWithLR());
    }

    default public String ifTest(String test, LRSupplier content) {
        return String.format("<if test=\"%s\">%s\n</if> ", test, content.getWithLR());
    }

    default public String ifParameterNotNull(LRSupplier content) {
        return String.format("<if test=\"_parameter != null\">%s\n</if> ", content.getWithLR());
    }

    default public String parameterNotNull(String message) {
        return this.variableNotNull("_parameter", message);
    }

    default public String variableIsTrue(String variable, String message) {
        return "\n${@io.mybatis.provider.util.Assert@isTrue(" + variable + ", '" + message + "')}\n";
    }

    default public String variableIsFalse(String variable, String message) {
        return "\n${@io.mybatis.provider.util.Assert@isFalse(" + variable + ", '" + message + "')}\n";
    }

    default public String variableNotNull(String variable, String message) {
        return "\n${@io.mybatis.provider.util.Assert@notNull(" + variable + ", '" + message + "')}\n";
    }

    default public String variableNotEmpty(String variable, String message) {
        return "\n${@io.mybatis.provider.util.Assert@notEmpty(" + variable + ", '" + message + "')}\n";
    }

    default public String whenTest(String test, LRSupplier content) {
        return String.format("\n<when test=\"%s\">%s\n</when> ", test, content.getWithLR());
    }

    default public String trim(String prefix, String suffix, String prefixOverrides, String suffixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" prefixOverrides=\"%s\" suffixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, prefixOverrides, suffixOverrides, suffix, content.getWithLR());
    }

    default public String trimPrefixOverrides(String prefix, String suffix, String prefixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" prefixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, prefixOverrides, suffix, content.getWithLR());
    }

    default public String trimSuffixOverrides(String prefix, String suffix, String suffixOverrides, LRSupplier content) {
        return String.format("\n<trim prefix=\"%s\" suffixOverrides=\"%s\" suffix=\"%s\">%s\n</trim> ", prefix, suffixOverrides, suffix, content.getWithLR());
    }

    default public String foreach(String collection, String item, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\">%s\n</foreach> ", collection, item, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, separator, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, String open, String close, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" open=\"%s\" close=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, open, close, separator, content.getWithLR());
    }

    default public String foreach(String collection, String item, String separator, String open, String close, String index, LRSupplier content) {
        return String.format("\n<foreach collection=\"%s\" item=\"%s\" index=\"%s\" open=\"%s\" close=\"%s\" separator=\"%s\">%s\n</foreach> ", collection, item, index, open, close, separator, content.getWithLR());
    }

    default public String bind(String name, String value) {
        return String.format("\n<bind name=\"%s\" value=\"%s\"/>", name, value);
    }

    public static interface SqlScript2
    extends SqlScript {
        @Override
        default public String getSql(EntityTable entity) {
            return this.getSql(entity, this);
        }

        public String getSql(EntityTable var1, SqlScript var2);
    }

    public static interface LRSupplier
    extends Supplier<String> {
        default public String getWithLR() {
            String str = (String)this.get();
            if (!str.isEmpty() && str.charAt(0) == SqlScript.LF.charAt(0)) {
                return str;
            }
            return SqlScript.LF + str;
        }
    }
}

