/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.util;

import io.mybatis.provider.EntityField;
import io.mybatis.provider.NameConvert;
import java.util.Collection;
import java.util.Map;

public class Utils {
    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !Utils.isEmpty(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Utils.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !Utils.isBlank(str);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !Utils.isEmpty(array);
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !Utils.isEmpty(collection);
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return !Utils.isEmpty(map);
    }

    public static String convert(String name) {
        return NameConvert.getInstance().convert(name);
    }

    public static String convertEntityClass(Class<?> entityClass) {
        return NameConvert.getInstance().convertEntityClass(entityClass);
    }

    public static String convertEntityField(EntityField field) {
        return NameConvert.getInstance().convertEntityField(field);
    }
}

