/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.config.ConfigHelper;
import io.mybatis.provider.Entity;
import java.util.HashMap;
import java.util.Map;

public class EntityProps<T extends EntityProps> {
    protected Map<String, String> props;

    public String getProp(String prop) {
        String val;
        if (prop == null || prop.isEmpty()) {
            return null;
        }
        String string = val = this.props != null ? this.props.get(prop) : null;
        if (val == null) {
            val = ConfigHelper.getStr((String)prop);
        }
        return val;
    }

    public String getProp(String prop, String defaultValue) {
        String val = this.getProp(prop);
        return val != null ? val : defaultValue;
    }

    public Integer getPropInt(String prop) {
        String val = this.getProp(prop);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return null;
    }

    public Integer getPropInt(String prop, Integer defaultValue) {
        Integer val = this.getPropInt(prop);
        return val != null ? val : defaultValue;
    }

    public Boolean getPropBoolean(String prop) {
        String val = this.getProp(prop);
        return Boolean.parseBoolean(val);
    }

    public Boolean getPropBoolean(String prop, Boolean defaultValue) {
        String val = this.getProp(prop);
        return val != null ? Boolean.parseBoolean(val) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T setProp(String prop, String value) {
        if (this.props == null) {
            EntityProps entityProps = this;
            synchronized (entityProps) {
                if (this.props == null) {
                    this.props = new HashMap<String, String>();
                }
            }
        }
        this.props.put(prop, value);
        return (T)this;
    }

    public T setProp(Entity.Prop prop) {
        return this.setProp(prop.name(), prop.value());
    }

    public T setProps(Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.setProp(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    public String removeProp(String prop) {
        if (this.props != null) {
            String value = this.getProp(prop);
            this.props.remove(prop);
            return value;
        }
        return null;
    }

    public Map<String, String> props() {
        return this.props;
    }
}

