/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.EntityTable;
import io.mybatis.provider.Order;
import io.mybatis.provider.SqlScript;
import io.mybatis.provider.SqlScriptWrapper;
import io.mybatis.provider.SqlWrapper;
import io.mybatis.provider.defaults.AnnotationSqlWrapper;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.annotation.ProviderContext;

public class AnnotationSqlScriptWrapper
implements SqlScriptWrapper {
    @Override
    public SqlScript wrap(ProviderContext context, EntityTable entity, SqlScript sqlScript) {
        Class mapperType = context.getMapperType();
        Method mapperMethod = context.getMapperMethod();
        List<AnnotationSqlWrapper> wrappers = this.parseAnnotations(mapperType, ElementType.TYPE, mapperType.getAnnotations());
        wrappers.addAll(this.parseAnnotations(mapperMethod, ElementType.METHOD, mapperMethod.getAnnotations()));
        Parameter[] parameters = mapperMethod.getParameters();
        Annotation[][] parameterAnnotations = mapperMethod.getParameterAnnotations();
        for (int i = 0; i < parameters.length; ++i) {
            wrappers.addAll(this.parseAnnotations(parameters[i], ElementType.PARAMETER, parameterAnnotations[i]));
        }
        wrappers = wrappers.stream().distinct().sorted(Comparator.comparing(f -> ((Order)f).getOrder()).reversed()).collect(Collectors.toList());
        for (SqlScriptWrapper sqlScriptWrapper : wrappers) {
            sqlScript = sqlScriptWrapper.wrap(context, entity, sqlScript);
        }
        return sqlScript;
    }

    private List<AnnotationSqlWrapper> parseAnnotations(Object target, ElementType type, Annotation[] annotations) {
        ArrayList<Class<? extends AnnotationSqlWrapper>> classes = new ArrayList<Class<? extends AnnotationSqlWrapper>>();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == SqlWrapper.class) {
                classes.addAll(Arrays.asList(((SqlWrapper)annotation).value()));
                continue;
            }
            if (!annotationType.isAnnotationPresent(SqlWrapper.class)) continue;
            SqlWrapper annotationTypeAnnotation = annotationType.getAnnotation(SqlWrapper.class);
            classes.addAll(Arrays.asList(annotationTypeAnnotation.value()));
        }
        return classes.stream().map(c -> (AnnotationSqlWrapper)this.newInstance((Class)c, target, type, annotations)).collect(Collectors.toList());
    }

    public <T> T newInstance(Class instanceClass, Object target, ElementType type, Annotation[] annotations) {
        try {
            return instanceClass.getConstructor(Object.class, ElementType.class, Annotation[].class).newInstance(new Object[]{target, type, annotations});
        }
        catch (Exception e) {
            throw new RuntimeException("instance [ " + instanceClass + " ] error", e);
        }
    }
}

