/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.config.ConfigHelper;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.MsCustomize;
import io.mybatis.provider.SqlCache;
import io.mybatis.provider.SqlSourceCustomize;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;

public class Caching
extends XMLLanguageDriver {
    public static final Log log = LogFactory.getLog(Caching.class);
    private static final Map<String, SqlCache> CACHE_SQL = new ConcurrentHashMap<String, SqlCache>(ConfigHelper.getInt((String)"mybatis.provider.cacheSql.initSize", (Integer)1024));
    private static final Map<Configuration, Map<String, SqlSource>> CONFIGURATION_CACHE_KEY_MAP = new ConcurrentHashMap<Configuration, Map<String, SqlSource>>(4);
    private static final boolean USE_ONCE = ConfigHelper.getBoolean((String)"mybatis.provider.cacheSql.useOnce", (boolean)false);

    private static String cacheKey(ProviderContext providerContext) {
        return (providerContext.getMapperType().getName() + "." + providerContext.getMapperMethod().getName()).intern();
    }

    private static void isAnnotationPresentLang(ProviderContext providerContext) {
        Lang lang;
        Method mapperMethod = providerContext.getMapperMethod();
        if (mapperMethod.isAnnotationPresent(Lang.class) && (lang = mapperMethod.getAnnotation(Lang.class)).value() == Caching.class) {
            return;
        }
        throw new RuntimeException(mapperMethod + " need to configure @Lang(Caching.class) to use the Caching.cache method for caching");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cache(ProviderContext providerContext, EntityTable entity, Supplier<String> sqlScriptSupplier) {
        String cacheKey = Caching.cacheKey(providerContext);
        if (!CACHE_SQL.containsKey(cacheKey)) {
            Caching.isAnnotationPresentLang(providerContext);
            String string = cacheKey;
            synchronized (string) {
                if (!CACHE_SQL.containsKey(cacheKey)) {
                    CACHE_SQL.put(cacheKey, new SqlCache(Objects.requireNonNull(providerContext), Objects.requireNonNull(entity), Objects.requireNonNull(sqlScriptSupplier)));
                }
            }
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (CACHE_SQL.containsKey(script)) {
            String cacheKey = script;
            if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                String string = cacheKey;
                synchronized (string) {
                    if (!CONFIGURATION_CACHE_KEY_MAP.containsKey(configuration) || !CONFIGURATION_CACHE_KEY_MAP.get(configuration).containsKey(cacheKey)) {
                        SqlCache cache = CACHE_SQL.get(cacheKey);
                        if (cache == SqlCache.NULL) {
                            throw new RuntimeException(script + " => CACHE_SQL is NULL, you need to configure mybatis.provider.cacheSql.useOnce=false");
                        }
                        cache.getEntity().initRuntimeContext(configuration, cache.getProviderContext(), cacheKey);
                        Map cachekeyMap = CONFIGURATION_CACHE_KEY_MAP.computeIfAbsent(configuration, k -> new HashMap());
                        MappedStatement ms = configuration.getMappedStatement(cacheKey);
                        MsCustomize.SPI.customize(cache.getEntity(), ms, cache.getProviderContext());
                        String sqlScript = cache.getSqlScript();
                        if (log.isTraceEnabled()) {
                            log.trace("cacheKey - " + cacheKey + " :\n" + sqlScript + "\n");
                        }
                        SqlSource sqlSource = super.createSqlSource(configuration, sqlScript, parameterType);
                        sqlSource = SqlSourceCustomize.SPI.customize(sqlSource, cache.getEntity(), ms, cache.getProviderContext());
                        cachekeyMap.put(cacheKey, sqlSource);
                        if (USE_ONCE) {
                            CACHE_SQL.put(cacheKey, SqlCache.NULL);
                        }
                    }
                }
            }
            return CONFIGURATION_CACHE_KEY_MAP.get(configuration).get(cacheKey);
        }
        return super.createSqlSource(configuration, script, parameterType);
    }
}

