/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.defaults.GenericTypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class EntityField {
    protected Class<?> entityClass;
    protected Field field;

    public EntityField() {
    }

    public EntityField(Class<?> entityClass, Field field) {
        this.entityClass = entityClass;
        this.field = field;
        this.field.setAccessible(true);
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return GenericTypeResolver.resolveFieldClass(this.field, this.entityClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    public Object get(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting field value by reflection", e);
        }
    }

    public void set(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error in reflection setting field value", e);
        }
    }
}

