/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityProps;
import io.mybatis.provider.defaults.GenericTypeResolver;
import io.mybatis.provider.util.Utils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class EntityTable
extends EntityProps<EntityTable> {
    public static final Pattern DELIMITER = Pattern.compile("^[`\\[\"]?(.*?)[`\\]\"]?$");
    public static final String RESULT_MAP_NAME = "BaseProviderResultMap";
    protected String table;
    protected String catalog;
    protected String schema;
    protected String style;
    protected Class<?> entityClass;
    protected List<EntityColumn> columns;
    protected boolean ready;
    protected String resultMap;
    protected boolean autoResultMap;
    protected List<ResultMap> resultMaps;
    protected Class<?>[] excludeSuperClasses;
    protected Class<?>[] excludeFieldTypes;
    protected String[] excludeFields;
    protected Set<Configuration> initConfiguration = new HashSet<Configuration>();

    protected EntityTable(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public static EntityTable of(Class<?> entityClass) {
        return new EntityTable(entityClass);
    }

    public String tableName() {
        return Stream.of(this.catalog(), this.schema(), this.table()).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("."));
    }

    public List<EntityColumn> columns() {
        if (this.columns == null) {
            this.columns = new ArrayList<EntityColumn>();
        }
        return this.columns;
    }

    public List<EntityField> fields() {
        return this.columns().stream().map(EntityColumn::field).collect(Collectors.toList());
    }

    public List<String> columnNames() {
        return this.columns().stream().map(EntityColumn::column).collect(Collectors.toList());
    }

    public List<String> fieldNames() {
        return this.columns().stream().map(EntityColumn::property).collect(Collectors.toList());
    }

    public void addColumn(EntityColumn column) {
        if (!this.columns().contains(column)) {
            if (column.field().getDeclaringClass() != this.entityClass()) {
                this.columns().add(0, column);
            } else {
                this.columns().add(column);
            }
            column.entityTable(this);
        } else {
            EntityColumn existsColumn = this.columns().remove(this.columns().indexOf(column));
            this.columns().add(0, existsColumn);
        }
    }

    protected boolean canUseResultMaps(ProviderContext providerContext, String cacheKey) {
        if (this.resultMaps != null && !this.resultMaps.isEmpty() && providerContext.getMapperMethod().isAnnotationPresent(SelectProvider.class)) {
            Class resultType = this.resultMaps.get(0).getType();
            if (resultType == providerContext.getMapperMethod().getReturnType()) {
                return true;
            }
            Class<?> returnType = GenericTypeResolver.getReturnType(providerContext.getMapperMethod(), providerContext.getMapperType());
            return resultType == returnType;
        }
        return false;
    }

    public boolean useResultMaps() {
        return this.resultMaps != null || this.autoResultMap || Utils.isNotEmpty(this.resultMap);
    }

    protected boolean hasBeenReplaced(Configuration configuration, String cacheKey) {
        MappedStatement mappedStatement = configuration.getMappedStatement(cacheKey);
        if (mappedStatement.getResultMaps() != null && mappedStatement.getResultMaps().size() > 0) {
            return mappedStatement.getResultMaps().get(0) == this.resultMaps.get(0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntimeContext(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        if (!this.initConfiguration.contains(configuration)) {
            this.initResultMap(configuration, providerContext, cacheKey);
            this.initConfiguration.add(configuration);
        }
        if (this.canUseResultMaps(providerContext, cacheKey)) {
            String string = cacheKey;
            synchronized (string) {
                if (!this.hasBeenReplaced(configuration, cacheKey)) {
                    MetaObject metaObject = configuration.newMetaObject((Object)configuration.getMappedStatement(cacheKey));
                    metaObject.setValue("resultMaps", Collections.unmodifiableList(this.resultMaps));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResultMap(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        if (Utils.isNotEmpty(this.resultMap)) {
            EntityTable entityTable = this;
            synchronized (entityTable) {
                if (this.resultMaps == null) {
                    this.resultMaps = new ArrayList<ResultMap>();
                    String resultMapId = this.generateResultMapId(providerContext, this.resultMap);
                    if (configuration.hasResultMap(resultMapId)) {
                        this.resultMaps.add(configuration.getResultMap(resultMapId));
                    } else if (configuration.hasResultMap(this.resultMap)) {
                        this.resultMaps.add(configuration.getResultMap(this.resultMap));
                    } else {
                        throw new RuntimeException(this.entityClass().getName() + " configured resultMap: " + this.resultMap + " not found");
                    }
                }
            }
        }
        if (this.autoResultMap) {
            EntityTable entityTable = this;
            synchronized (entityTable) {
                if (this.resultMaps == null) {
                    this.resultMaps = new ArrayList<ResultMap>();
                    ResultMap resultMap = this.genResultMap(configuration, providerContext, cacheKey);
                    this.resultMaps.add(resultMap);
                    configuration.addResultMap(resultMap);
                }
            }
        }
    }

    protected String generateResultMapId(ProviderContext providerContext, String resultMapId) {
        if (resultMapId.indexOf(".") > 0) {
            return resultMapId;
        }
        return providerContext.getMapperType().getName() + "." + resultMapId;
    }

    protected ResultMap genResultMap(Configuration configuration, ProviderContext providerContext, String cacheKey) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (EntityColumn entityColumn : this.selectColumns()) {
            String column = entityColumn.column();
            Matcher matcher = DELIMITER.matcher(column);
            if (matcher.find()) {
                column = matcher.group(1);
            }
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, entityColumn.property(), column, entityColumn.javaType());
            if (entityColumn.jdbcType != null && entityColumn.jdbcType != JdbcType.UNDEFINED) {
                builder.jdbcType(entityColumn.jdbcType);
            }
            if (entityColumn.typeHandler != null && entityColumn.typeHandler != UnknownTypeHandler.class) {
                try {
                    builder.typeHandler(this.getTypeHandlerInstance(entityColumn.javaType(), entityColumn.typeHandler));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (entityColumn.id) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            resultMappings.add(builder.build());
        }
        String resultMapId = this.generateResultMapId(providerContext, RESULT_MAP_NAME);
        ResultMap.Builder builder = new ResultMap.Builder(configuration, resultMapId, this.entityClass(), resultMappings, Boolean.valueOf(true));
        return builder.build();
    }

    public TypeHandler getTypeHandlerInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, (Throwable)e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, (Throwable)e);
        }
    }

    public List<EntityColumn> idColumns() {
        List<EntityColumn> idColumns = this.columns().stream().filter(EntityColumn::id).collect(Collectors.toList());
        if (idColumns.isEmpty()) {
            return this.columns();
        }
        return idColumns;
    }

    public List<EntityColumn> normalColumns() {
        return this.columns().stream().filter(column -> !column.id()).collect(Collectors.toList());
    }

    public List<EntityColumn> selectColumns() {
        return this.columns().stream().filter(EntityColumn::selectable).collect(Collectors.toList());
    }

    public List<EntityColumn> whereColumns() {
        return this.columns();
    }

    public List<EntityColumn> insertColumns() {
        return this.columns().stream().filter(EntityColumn::insertable).collect(Collectors.toList());
    }

    public List<EntityColumn> updateColumns() {
        return this.columns().stream().filter(EntityColumn::updatable).collect(Collectors.toList());
    }

    public Optional<List<EntityColumn>> groupByColumns() {
        return Optional.empty();
    }

    public Optional<List<EntityColumn>> havingColumns() {
        return Optional.empty();
    }

    public Optional<List<EntityColumn>> orderByColumns() {
        List orderByColumns = this.columns().stream().filter(c -> Utils.isNotEmpty(c.orderBy)).sorted(Comparator.comparing(EntityColumn::orderByPriority)).collect(Collectors.toList());
        if (orderByColumns.size() > 0) {
            return Optional.of(orderByColumns);
        }
        return Optional.empty();
    }

    public String baseColumnList() {
        return this.selectColumns().stream().map(EntityColumn::column).collect(Collectors.joining(","));
    }

    public String baseColumnAsPropertyList() {
        if (this.useResultMaps()) {
            return this.baseColumnList();
        }
        return this.selectColumns().stream().map(EntityColumn::columnAsProperty).collect(Collectors.joining(","));
    }

    public String insertColumnList() {
        return this.insertColumns().stream().map(EntityColumn::column).collect(Collectors.joining(","));
    }

    public Optional<String> groupByColumnList() {
        Optional<List<EntityColumn>> groupByColumns = this.groupByColumns();
        return groupByColumns.map(entityColumns -> entityColumns.stream().map(EntityColumn::column).collect(Collectors.joining(",")));
    }

    public Optional<String> groupByColumn() {
        Optional<String> groupByColumnList = this.groupByColumnList();
        return groupByColumnList.map(s -> " GROUP BY " + s);
    }

    public Optional<String> havingColumnList() {
        Optional<List<EntityColumn>> havingColumns = this.havingColumns();
        return havingColumns.map(entityColumns -> entityColumns.stream().map(EntityColumn::column).collect(Collectors.joining(",")));
    }

    public Optional<String> havingColumn() {
        Optional<String> havingColumnList = this.havingColumnList();
        return havingColumnList.map(s -> " HAVING " + s);
    }

    public Optional<String> orderByColumnList() {
        Optional<List<EntityColumn>> orderByColumns = this.orderByColumns();
        return orderByColumns.map(entityColumns -> entityColumns.stream().map(column -> column.column() + " " + column.orderBy()).collect(Collectors.joining(",")));
    }

    public Optional<String> orderByColumn() {
        Optional<String> orderColumnList = this.orderByColumnList();
        return orderColumnList.map(s -> " ORDER BY " + s);
    }

    public boolean isExcludeSuperClass(Class<?> superClass) {
        if (this.excludeSuperClasses != null) {
            for (Class<?> clazz : this.excludeSuperClasses) {
                if (clazz != superClass) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExcludeField(EntityField field) {
        if (this.excludeFieldTypes != null) {
            Class<?> fieldType = field.getType();
            for (Class<?> clazz : this.excludeFieldTypes) {
                if (clazz != fieldType) continue;
                return true;
            }
        }
        if (this.excludeFields != null) {
            String fieldName = field.getName();
            for (String excludeField : this.excludeFields) {
                if (!excludeField.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityTable)) {
            return false;
        }
        EntityTable entity = (EntityTable)o;
        return this.tableName().equals(entity.tableName());
    }

    public int hashCode() {
        return Objects.hash(this.tableName());
    }

    public String toString() {
        return this.tableName();
    }

    public String table() {
        return this.table;
    }

    public EntityTable table(String table) {
        this.table = table;
        return this;
    }

    public String catalog() {
        return this.catalog;
    }

    public EntityTable catalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String schema() {
        return this.schema;
    }

    public EntityTable schema(String schema) {
        this.schema = schema;
        return this;
    }

    public String style() {
        return this.style;
    }

    public EntityTable style(String style) {
        this.style = style;
        return this;
    }

    public Class<?> entityClass() {
        return this.entityClass;
    }

    public EntityTable entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public EntityTable columns(List<EntityColumn> columns) {
        this.columns = columns;
        return this;
    }

    public boolean ready() {
        return this.ready;
    }

    public EntityTable ready(boolean ready) {
        this.ready = ready;
        return this;
    }

    public String resultMap() {
        return this.resultMap;
    }

    public EntityTable resultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    public boolean autoResultMap() {
        return this.autoResultMap;
    }

    public EntityTable autoResultMap(boolean autoResultMap) {
        this.autoResultMap = autoResultMap;
        return this;
    }

    public Class<?>[] excludeSuperClasses() {
        return this.excludeSuperClasses;
    }

    public EntityTable excludeSuperClasses(Class<?>[] excludeSuperClasses) {
        this.excludeSuperClasses = excludeSuperClasses;
        return this;
    }

    public Class<?>[] excludeFieldTypes() {
        return this.excludeFieldTypes;
    }

    public EntityTable excludeFieldTypes(Class<?>[] excludeFieldTypes) {
        this.excludeFieldTypes = excludeFieldTypes;
        return this;
    }

    public String[] excludeFields() {
        return this.excludeFields;
    }

    public EntityTable excludeFields(String[] excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }
}

