/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.EntityTable;
import io.mybatis.provider.EntityTableFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingEntityTableFactory
implements EntityTableFactory {
    private final Map<Class<?>, EntityTable> ENTITY_CLASS_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityTable createEntityTable(Class<?> entityClass, EntityTableFactory.Chain chain) {
        if (this.ENTITY_CLASS_MAP.get(entityClass) == null) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (this.ENTITY_CLASS_MAP.get(entityClass) == null) {
                    EntityTable entityTable = chain.createEntityTable(entityClass);
                    if (entityTable != null) {
                        this.ENTITY_CLASS_MAP.put(entityClass, entityTable);
                    } else {
                        return null;
                    }
                }
            }
        }
        return this.ENTITY_CLASS_MAP.get(entityClass);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

