/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.keysql;

import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.keysql.GenId;
import java.sql.Statement;
import java.util.Date;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;

public class GenIdKeyGenerator
implements KeyGenerator {
    private final GenId<?> genId;
    private final EntityTable table;
    private final EntityColumn column;
    private final Configuration configuration;
    private final boolean executeBefore;
    private Date firstTime;

    public GenIdKeyGenerator(GenId<?> genId, EntityTable table, EntityColumn column, Configuration configuration, boolean executeBefore) {
        this.genId = genId;
        this.table = table;
        this.column = column;
        this.configuration = configuration;
        this.executeBefore = executeBefore;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (this.executeBefore) {
            this.genId(parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (!this.executeBefore) {
            this.genId(parameter);
        }
    }

    public void genIdFirstTime(Object parameter) {
        if (this.runFirstTime()) {
            this.firstTime = new Date();
            this.genId(parameter);
        }
    }

    public void genId(Object parameter) {
        Object id = this.genId.genId(this.table, this.column);
        this.configuration.newMetaObject(parameter).setValue(this.column.property(), id);
    }

    public boolean runFirstTime() {
        return this.executeBefore && this.firstTime == null;
    }
}

