/*
 * Copyright 2020-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.mybatis.provider.style;

import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;

/**
 * @author liuzh
 */
public class UpperStyle extends NormalStyle {
  @Override
  public String getStyle() {
    return UPPER;
  }

  @Override
  public String tableName(Class<?> entityClass) {
    return super.tableName(entityClass).toUpperCase();
  }

  @Override
  public String columnName(EntityTable entityTable, EntityField field) {
    return super.columnName(entityTable, field).toUpperCase();
  }

}
