/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.Order;
import io.mybatis.provider.util.ServiceLoaderUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public interface EntityClassFinder
extends Order {
    public static final Map<MapperTypeMethod, Optional<Class<?>>> ENTITY_CLASS_MAP = new ConcurrentHashMap();

    public static Optional<Class<?>> find(Class<?> mapperType, Method mapperMethod) {
        Objects.requireNonNull(mapperType);
        return ENTITY_CLASS_MAP.computeIfAbsent(new MapperTypeMethod(mapperType, mapperMethod), mapperTypeMethod -> {
            for (EntityClassFinder instance : EntityClassFinderInstance.getInstances()) {
                Optional<Class<?>> optionalClass = instance.findEntityClass(mapperType, mapperMethod);
                if (!optionalClass.isPresent()) continue;
                return optionalClass;
            }
            return Optional.empty();
        });
    }

    public Optional<Class<?>> findEntityClass(Class<?> var1, Method var2);

    public boolean isEntityClass(Class<?> var1);

    public static class EntityClassFinderInstance {
        private static volatile List<EntityClassFinder> INSTANCES;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static List<EntityClassFinder> getInstances() {
            if (INSTANCES != null) return INSTANCES;
            Class<EntityClassFinder> clazz = EntityClassFinder.class;
            synchronized (EntityClassFinder.class) {
                if (INSTANCES != null) return INSTANCES;
                INSTANCES = ServiceLoaderUtil.getInstances(EntityClassFinder.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCES;
            }
        }
    }

    public static class MapperTypeMethod {
        private final Class<?> mapperType;
        private final Method mapperMethod;

        public MapperTypeMethod(Class<?> mapperType, Method mapperMethod) {
            this.mapperType = mapperType;
            this.mapperMethod = mapperMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapperTypeMethod that = (MapperTypeMethod)o;
            return Objects.equals(this.mapperType, that.mapperType) && Objects.equals(this.mapperMethod, that.mapperMethod);
        }

        public int hashCode() {
            return Objects.hash(this.mapperType, this.mapperMethod);
        }

        public String toString() {
            return (this.mapperType != null ? this.mapperType.getSimpleName() + "." : "") + (this.mapperMethod != null ? this.mapperMethod.getName() : "");
        }
    }
}

