/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.EntityClassFinder;
import io.mybatis.provider.defaults.GenericTypeResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;

public abstract class GenericEntityClassFinder
implements EntityClassFinder {
    @Override
    public Optional<Class<?>> findEntityClass(Class<?> mapperType, Method mapperMethod) {
        if (mapperMethod != null) {
            Optional<Class<?>> optionalClass = this.getEntityClassByMapperMethodReturnType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getEntityClassByMapperMethodParamTypes(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            optionalClass = this.getEntityClassByMapperMethodAndMapperType(mapperType, mapperMethod);
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
        }
        return this.getEntityClassByMapperType(mapperType);
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodReturnType(Class<?> mapperType, Method mapperMethod) {
        Class<?> returnType = GenericTypeResolver.getReturnType(mapperMethod, mapperType);
        return this.isEntityClass(returnType) ? Optional.of(returnType) : Optional.empty();
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodParamTypes(Class<?> mapperType, Method mapperMethod) {
        return this.getEntityClassByTypes(GenericTypeResolver.resolveParamTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getEntityClassByMapperMethodAndMapperType(Class<?> mapperType, Method mapperMethod) {
        return this.getEntityClassByTypes(GenericTypeResolver.resolveMapperTypes(mapperMethod, mapperType));
    }

    protected Optional<Class<?>> getEntityClassByMapperType(Class<?> mapperType) {
        return this.getEntityClassByTypes(GenericTypeResolver.resolveMapperTypes(mapperType));
    }

    protected Optional<Class<?>> getEntityClassByType(Type type) {
        if (type instanceof Class) {
            return Optional.of((Class)type);
        }
        if (type instanceof GenericTypeResolver.ParameterizedTypeImpl) {
            return this.getEntityClassByTypes(((GenericTypeResolver.ParameterizedTypeImpl)type).getActualTypeArguments());
        }
        if (type instanceof GenericTypeResolver.WildcardTypeImpl) {
            Optional<Class<?>> optionalClass = this.getEntityClassByTypes(((GenericTypeResolver.WildcardTypeImpl)type).getLowerBounds());
            if (optionalClass.isPresent()) {
                return optionalClass;
            }
            return this.getEntityClassByTypes(((GenericTypeResolver.WildcardTypeImpl)type).getUpperBounds());
        }
        if (type instanceof GenericTypeResolver.GenericArrayTypeImpl) {
            return this.getEntityClassByType(((GenericTypeResolver.GenericArrayTypeImpl)type).getGenericComponentType());
        }
        return Optional.empty();
    }

    protected Optional<Class<?>> getEntityClassByTypes(Type[] types) {
        for (Type type : types) {
            Optional<Class<?>> optionalClass = this.getEntityClassByType(type);
            if (!optionalClass.isPresent() || !this.isEntityClass(optionalClass.get())) continue;
            return optionalClass;
        }
        return Optional.empty();
    }
}

