/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.keysql;

import io.mybatis.config.ConfigHelper;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.keysql.GenId;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class GenIdKeyGenerator
implements KeyGenerator {
    private static volatile Integer CONCURRENCY;
    private final GenId<?> genId;
    private final EntityTable table;
    private final EntityColumn column;
    private final Configuration configuration;
    private final boolean executeBefore;
    private AtomicInteger count = new AtomicInteger(0);

    public GenIdKeyGenerator(GenId<?> genId, EntityTable table, EntityColumn column, Configuration configuration, boolean executeBefore) {
        this.genId = genId;
        this.table = table;
        this.column = column;
        this.configuration = configuration;
        this.executeBefore = executeBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getConcurrency() {
        if (CONCURRENCY != null) return CONCURRENCY;
        Class<GenIdKeyGenerator> clazz = GenIdKeyGenerator.class;
        synchronized (GenIdKeyGenerator.class) {
            if (CONCURRENCY != null) return CONCURRENCY;
            CONCURRENCY = ConfigHelper.getInt((String)"mybatis.provider.genId.concurrency", (Integer)1000);
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONCURRENCY;
        }
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (this.executeBefore) {
            this.genId(parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (!this.executeBefore) {
            this.genId(parameter);
        }
    }

    public void genId(Object parameter) {
        if (parameter != null) {
            if (this.table.entityClass().isInstance(parameter)) {
                MetaObject metaObject = this.configuration.newMetaObject(parameter);
                if (metaObject.getValue(this.column.property()) == null) {
                    Object id = this.genId.genId(this.table, this.column);
                    metaObject.setValue(this.column.property(), id);
                }
            } else if (parameter instanceof Map) {
                new HashSet(((Map)parameter).values()).forEach(this::genId);
            } else if (parameter instanceof Iterator) {
                Iterator iterator = (Iterator)parameter;
                HashSet set = new HashSet();
                while (iterator.hasNext()) {
                    set.add(iterator.next());
                }
                set.forEach(this::genId);
            } else if (parameter instanceof Iterable) {
                HashSet set = new HashSet();
                ((Iterable)parameter).forEach(set::add);
                set.forEach(this::genId);
            }
        }
    }

    public void prepare(Object parameter) {
        if (this.executeBefore && this.count.get() < GenIdKeyGenerator.getConcurrency()) {
            this.count.incrementAndGet();
            this.genId(parameter);
        }
    }
}

