/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.service;

import io.mybatis.common.core.Code;
import io.mybatis.common.util.Assert;
import io.mybatis.mapper.BaseMapper;
import io.mybatis.mapper.example.Example;
import io.mybatis.mapper.fn.Fn;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import io.mybatis.service.BaseService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractService<T, I extends Serializable, M extends BaseMapper<T, I>>
implements BaseService<T, I> {
    protected M baseMapper;

    @Autowired
    public void setBaseMapper(M baseMapper) {
        this.baseMapper = baseMapper;
    }

    @Override
    public T save(T entity) {
        Assert.isTrue((this.baseMapper.insert(entity) == 1 ? 1 : 0) != 0, (Code)Code.SAVE_FAILURE);
        return entity;
    }

    @Override
    public T saveSelective(T entity) {
        Assert.isTrue((this.baseMapper.insertSelective(entity) == 1 ? 1 : 0) != 0, (Code)Code.SAVE_FAILURE);
        return entity;
    }

    @Override
    public T update(T entity) {
        Assert.isTrue((this.baseMapper.updateByPrimaryKey(entity) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
        return entity;
    }

    @Override
    public T updateSelective(T entity) {
        Assert.isTrue((this.baseMapper.updateByPrimaryKeySelective(entity) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
        return entity;
    }

    @Override
    public T updateSelective(T entity, Fn<T, Object> ... forceUpdateFields) {
        Assert.isTrue((this.baseMapper.updateByPrimaryKeySelectiveWithForceFields(entity, Fn.of(forceUpdateFields)) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
        return entity;
    }

    @Override
    public boolean pkHasValue(T entity) {
        EntityTable entityTable = this.baseMapper.entityTable();
        List idColumns = entityTable.idColumns();
        return ((EntityColumn)idColumns.get(0)).field().get(entity) != null;
    }

    @Override
    public T saveOrUpdate(T entity) {
        if (this.pkHasValue(entity)) {
            return this.update(entity);
        }
        return this.save(entity);
    }

    @Override
    public T saveOrUpdateSelective(T entity) {
        if (this.pkHasValue(entity)) {
            return this.updateSelective(entity);
        }
        return this.saveSelective(entity);
    }

    @Override
    public int delete(T entity) {
        return this.baseMapper.delete(entity);
    }

    @Override
    public int deleteById(I id) {
        int count = this.baseMapper.deleteByPrimaryKey(id);
        Assert.isTrue((count == 1 ? 1 : 0) != 0, (Code)Code.DELETE_FAILURE);
        return count;
    }

    @Override
    public <F> int deleteByFieldList(Fn<T, F> field, List<F> fieldValueList) {
        return this.baseMapper.deleteByFieldList(field, fieldValueList);
    }

    @Override
    public T findById(I id) {
        return this.baseMapper.selectByPrimaryKey(id).orElse(null);
    }

    @Override
    public T findOne(T entity) {
        return this.baseMapper.selectOne(entity).orElse(null);
    }

    @Override
    public List<T> findList(T entity) {
        return this.baseMapper.selectList(entity);
    }

    @Override
    public <F> List<T> findByFieldList(Fn<T, F> field, List<F> fieldValueList) {
        return this.baseMapper.selectByFieldList(field, fieldValueList);
    }

    @Override
    public List<T> findAll() {
        return this.baseMapper.selectList(null);
    }

    @Override
    public long count(T entity) {
        return this.baseMapper.selectCount(entity);
    }

    @Override
    public int delete(Example<T> example) {
        return this.baseMapper.deleteByExample(example);
    }

    @Override
    public int update(T entity, Example<T> example) {
        return this.baseMapper.updateByExample(entity, example);
    }

    @Override
    public int updateSelective(T entity, Example<T> example) {
        return this.baseMapper.updateByExampleSelective(entity, example);
    }

    @Override
    public T findOne(Example<T> example) {
        return this.baseMapper.selectOneByExample(example).orElse(null);
    }

    @Override
    public List<T> findList(Example<T> example) {
        return this.baseMapper.selectByExample(example);
    }

    @Override
    public long count(Example<T> example) {
        return this.baseMapper.countByExample(example);
    }
}

