/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc;

import io.nanovc.AreaEntry;
import io.nanovc.ContentAPI;
import io.nanovc.RepoPath;
import java.util.Comparator;
import java.util.stream.Stream;

public interface AreaAPI<TContent extends ContentAPI>
extends Iterable<AreaEntry<TContent>> {
    public boolean hasAnyContent();

    default public boolean hasContent(String absolutePath) {
        return this.hasContent(RepoPath.at(absolutePath));
    }

    public boolean hasContent(RepoPath var1);

    default public void putContent(String absolutePath, TContent content) {
        this.putContent(RepoPath.at(absolutePath), content);
    }

    default public void putContent(AreaEntry<TContent> areaEntry) {
        this.putContent(areaEntry.path, areaEntry.content);
    }

    public void putContent(RepoPath var1, TContent var2);

    default public TContent getContent(String absolutePath) {
        return this.getContent(RepoPath.at(absolutePath));
    }

    public TContent getContent(RepoPath var1);

    default public void removeContent(String absolutePath) {
        this.removeContent(RepoPath.at(absolutePath));
    }

    public void removeContent(RepoPath var1);

    public void replaceAllContent(Stream<AreaEntry<TContent>> var1);

    public Stream<AreaEntry<ContentAPI>> getContentStream();

    public Stream<AreaEntry<TContent>> getTypedContentStream();

    public void clear();

    default public String asListString() {
        StringBuilder stringBuilder = new StringBuilder();
        Stream<AreaEntry<ContentAPI>> contentStream = this.getContentStream();
        contentStream = contentStream.sorted(Comparator.comparing(areaEntry -> ((RepoPath)areaEntry.path.toAbsolutePath()).path));
        contentStream.forEachOrdered(areaEntry -> {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(((RepoPath)areaEntry.path.toAbsolutePath()).path);
            stringBuilder.append(" : ");
            stringBuilder.append(areaEntry.content);
        });
        return stringBuilder.toString();
    }
}

